/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.editor;

import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.copy.MerkleCopy;
import com.swirlds.common.merkle.route.MerkleRouteIterator;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.state.editor.StateEditor;
import com.swirlds.platform.state.editor.StateEditorOperation;
import com.swirlds.platform.state.editor.StateEditorRoot;
import com.swirlds.platform.state.editor.StateEditorUtils;
import com.swirlds.platform.state.signed.ReservedSignedState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hashable;
import picocli.CommandLine;

@CommandLine.Command(name="swap", mixinStandardHelpOptions=true, description={"Swap two nodes."})
@SubcommandOf(value=StateEditorRoot.class)
public class StateEditorSwap
extends StateEditorOperation {
    private static final Logger logger = LogManager.getLogger(StateEditorSwap.class);
    private String pathA;
    private String pathB = "";

    @CommandLine.Parameters(index="0", description={"The first merkle node."})
    private void setPathA(String pathA) {
        this.pathA = pathA;
    }

    @CommandLine.Parameters(index="1", arity="0..1", description={"The second merkle node."})
    private void setPathB(String pathB) {
        this.pathB = pathB;
    }

    @Override
    public void run() {
        try (ReservedSignedState reservedSignedState = this.getStateEditor().getState("StateEditorLoad.swap()");){
            StateEditor.ParentInfo parentInfoA = this.getStateEditor().getParentInfo(this.pathA);
            StateEditor.ParentInfo parentInfoB = this.getStateEditor().getParentInfo(this.pathB);
            MerkleNodeState merkleTraversable = reservedSignedState.get().getState();
            MerkleNode nodeA = merkleTraversable.getRoot().getNodeAtRoute(parentInfoA.target());
            MerkleNode nodeB = merkleTraversable.getRoot().getNodeAtRoute(parentInfoB.target());
            if (logger.isInfoEnabled(LogMarker.CLI.getMarker())) {
                logger.info(LogMarker.CLI.getMarker(), "Swapping {} and {}", (Object)StateEditorUtils.formatNode(nodeA), (Object)StateEditorUtils.formatNode(nodeB));
            }
            if (nodeB != null) {
                nodeB.reserve();
            }
            MerkleCopy.copyTreeToLocation((MerkleInternal)parentInfoB.parent(), (int)parentInfoB.indexInParent(), (MerkleNode)nodeA);
            MerkleCopy.copyTreeToLocation((MerkleInternal)parentInfoA.parent(), (int)parentInfoA.indexInParent(), (MerkleNode)nodeB);
            if (nodeB != null) {
                nodeB.release();
            }
            new MerkleRouteIterator(merkleTraversable.getRoot(), parentInfoA.parent().getRoute()).forEachRemaining(Hashable::invalidateHash);
            new MerkleRouteIterator(merkleTraversable.getRoot(), parentInfoB.parent().getRoute()).forEachRemaining(Hashable::invalidateHash);
        }
    }
}

