/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.reconnect;

import com.swirlds.base.time.Time;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.utility.throttle.RateLimitedLogger;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.node.NodeId;

public class ReconnectThrottle {
    private static final Logger logger = LogManager.getLogger(ReconnectThrottle.class);
    private final ReconnectConfig config;
    private final HashMap<NodeId, Instant> lastReconnectTime;
    private NodeId reconnectingNode;
    private final RateLimitedLogger alreadyHelpingLogger;
    private final RateLimitedLogger throttledLogger;
    private Supplier<Instant> currentTime;

    public ReconnectThrottle(@NonNull ReconnectConfig config, @NonNull Time time) {
        this.config = Objects.requireNonNull(config, "config must not be null");
        Objects.requireNonNull(time);
        this.lastReconnectTime = new HashMap();
        this.reconnectingNode = null;
        this.currentTime = Instant::now;
        this.alreadyHelpingLogger = new RateLimitedLogger(logger, time, config.minimumTimeBetweenReconnects());
        this.throttledLogger = new RateLimitedLogger(logger, time, config.minimumTimeBetweenReconnects());
    }

    private void forgetOldReconnects(Instant now) {
        Iterator<Instant> iterator = this.lastReconnectTime.values().iterator();
        while (iterator.hasNext()) {
            Duration elapsed = Duration.between(iterator.next(), now);
            if (!this.config.minimumTimeBetweenReconnects().minus(elapsed).isNegative()) continue;
            iterator.remove();
        }
    }

    public synchronized boolean initiateReconnect(NodeId nodeId) {
        if (this.reconnectingNode != null) {
            this.alreadyHelpingLogger.info(LogMarker.RECONNECT.getMarker(), "This node is actively helping node {} to reconnect, rejecting concurrent reconnect request from node {}", new Object[]{this.reconnectingNode, nodeId});
            return false;
        }
        Instant now = this.currentTime.get();
        this.forgetOldReconnects(now);
        if (this.lastReconnectTime.containsKey(nodeId)) {
            this.throttledLogger.info(LogMarker.RECONNECT.getMarker(), "Rejecting reconnect request from node {} due to a previous reconnect attempt at {}", new Object[]{nodeId, this.lastReconnectTime.get(nodeId)});
            return false;
        }
        this.reconnectingNode = nodeId;
        this.lastReconnectTime.put(nodeId, now);
        return true;
    }

    public synchronized void reconnectAttemptFinished() {
        this.reconnectingNode = null;
    }

    public int getNumberOfRecentReconnects() {
        return this.lastReconnectTime.size();
    }

    public void setCurrentTime(Supplier<Instant> currentTime) {
        this.currentTime = currentTime;
    }
}

