/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public class OtherParentMatrixFactory {
    public static List<List<Double>> createBalancedOtherParentMatrix(int numNodes) {
        return OtherParentMatrixFactory.createOtherParentMatrix(numNodes, (creator, otherParent) -> {
            if (creator == otherParent) {
                return 0.0;
            }
            return 1.0;
        });
    }

    public static List<List<Double>> createForcedOtherParentMatrix(int numNodes, int nextOtherParent) {
        return OtherParentMatrixFactory.createOtherParentMatrix(numNodes, (creator, otherParent) -> {
            if (creator == otherParent) {
                return 0.0;
            }
            if (otherParent == nextOtherParent) {
                return 1.0;
            }
            return 0.0;
        });
    }

    public static List<List<Double>> createCliqueOtherParentMatrix(int numNodes, Map<Integer, Integer> cliques) {
        return OtherParentMatrixFactory.createOtherParentMatrix(numNodes, (creator, otherParent) -> {
            if (creator == otherParent) {
                return 0.0;
            }
            if (((Integer)cliques.get(creator)).equals(cliques.get(otherParent))) {
                return 1.0;
            }
            return 0.02;
        });
    }

    public static List<List<Double>> createPartitionedOtherParentAffinityMatrix(int numNodes, Collection<Integer> nodeIDsInThisPartition) {
        return OtherParentMatrixFactory.createOtherParentMatrix(numNodes, (creator, otherParent) -> {
            if (creator == otherParent) {
                return 0.0;
            }
            if (nodeIDsInThisPartition.contains(creator) && nodeIDsInThisPartition.contains(otherParent) || !nodeIDsInThisPartition.contains(creator) && !nodeIDsInThisPartition.contains(otherParent)) {
                return 1.0;
            }
            return 0.0;
        });
    }

    public static List<List<Double>> createShunnedNodeOtherParentAffinityMatrix(int numNodes, int shunnedNode) {
        return OtherParentMatrixFactory.createOtherParentMatrix(numNodes, (creator, otherParent) -> {
            if (creator == otherParent) {
                return 0.0;
            }
            if (otherParent == shunnedNode) {
                return 0.0;
            }
            return 1.0;
        });
    }

    private static List<List<Double>> createOtherParentMatrix(int numSources, BiFunction<Integer, Integer, Double> function) {
        ArrayList<List<Double>> matrix = new ArrayList<List<Double>>(numSources);
        for (int creator = 0; creator < numSources; ++creator) {
            ArrayList<Double> row = new ArrayList<Double>(numSources);
            for (int otherParent = 0; otherParent < numSources; ++otherParent) {
                row.add(function.apply(creator, otherParent));
            }
            matrix.add(row);
        }
        return matrix;
    }
}

