/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.merkle.map;

import com.swirlds.demo.merkle.map.FCMTransactionHandler;
import com.swirlds.demo.platform.fs.stresstest.proto.BurnToken;
import com.swirlds.demo.platform.fs.stresstest.proto.FCMTransaction;
import com.swirlds.demo.platform.fs.stresstest.proto.FCMTxType;
import com.swirlds.demo.platform.fs.stresstest.proto.FCQTxType;
import com.swirlds.demo.platform.fs.stresstest.proto.MintToken;
import com.swirlds.demo.platform.fs.stresstest.proto.TransferBalance;
import com.swirlds.demo.platform.fs.stresstest.proto.TransferBalanceFCQ;
import com.swirlds.demo.platform.fs.stresstest.proto.TransferToken;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkle.test.fixtures.map.lifecycle.EntityType;
import com.swirlds.merkle.test.fixtures.map.lifecycle.TransactionType;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class FCMTransactionUtils {
    private static final Logger logger = LogManager.getLogger(FCMTransactionHandler.class);
    private static final Marker DEMO_INFO = MarkerManager.getMarker((String)"DEMO_INFO");
    private static final Marker ERROR = MarkerManager.getMarker((String)"EXCEPTION");

    public static TransactionType getTransactionType(FCMTransaction fcmTransaction) {
        String bodyCase = fcmTransaction.getBodyCase().toString();
        if (bodyCase.contains("CREATE")) {
            return TransactionType.Create;
        }
        if (bodyCase.contains("UPDATE")) {
            return TransactionType.Update;
        }
        if (bodyCase.contains("TRANSFER")) {
            return TransactionType.Transfer;
        }
        if (bodyCase.contains("DELETE_FCQ_NODE")) {
            return TransactionType.Update;
        }
        if (bodyCase.contains("DELETE")) {
            return TransactionType.Delete;
        }
        if (bodyCase.contains("APPEND")) {
            return TransactionType.Append;
        }
        if (bodyCase.contains("MINTTOKEN")) {
            return TransactionType.MintToken;
        }
        if (bodyCase.contains("TRANSFERTOKEN")) {
            return TransactionType.TransferToken;
        }
        if (bodyCase.contains("BURNTOKEN")) {
            return TransactionType.BurnToken;
        }
        if (bodyCase.contains("ASSORTED")) {
            if (bodyCase.contains("FCQ")) {
                FCQTxType txType = fcmTransaction.getAssortedFCQ().getTxType();
                switch (txType) {
                    case FCQCreate: {
                        return TransactionType.Create;
                    }
                    case FCQTransfer: {
                        return TransactionType.Transfer;
                    }
                    case FCQUpdate: {
                        return TransactionType.Update;
                    }
                    case FCQDelete: {
                        return TransactionType.Delete;
                    }
                }
                logger.error(LogMarker.EXCEPTION.getMarker(), "Invalid Assorted FCQ body in FCMTransaction: {}", (Object)bodyCase);
                return null;
            }
            FCMTxType txType = fcmTransaction.getAssortedAccount().getTxType();
            switch (txType) {
                case Create: {
                    return TransactionType.Create;
                }
                case Transfer: {
                    return TransactionType.Transfer;
                }
                case Update: {
                    return TransactionType.Update;
                }
                case Delete: {
                    return TransactionType.Delete;
                }
            }
            logger.error(LogMarker.EXCEPTION.getMarker(), "Invalid Assorted body in FCMTransaction: {}", (Object)bodyCase);
            return null;
        }
        logger.error(LogMarker.EXCEPTION.getMarker(), "Invalid body for TransactionType in FCMTransaction: {}", (Object)bodyCase);
        return null;
    }

    public static EntityType getEntityType(FCMTransaction fcmTransaction) {
        String bodyCase = fcmTransaction.getBodyCase().toString();
        if (bodyCase.contains("FCQ")) {
            return EntityType.FCQ;
        }
        if (bodyCase.contains("ACCOUNT") || bodyCase.equals("TRANSFERBALANCE")) {
            return EntityType.Crypto;
        }
        if (bodyCase.contains("TOKEN")) {
            return EntityType.NFT;
        }
        logger.error(LogMarker.EXCEPTION.getMarker(), "Invalid body for EntityType in FCMTransaction: {}", (Object)bodyCase);
        return null;
    }

    public static List<MapKey> getMapKeys(FCMTransaction fcmTransaction) {
        Object body = FCMTransactionUtils.getBodyField(fcmTransaction);
        ArrayList<MapKey> mapKeys = new ArrayList<MapKey>();
        if (body instanceof TransferBalance || body instanceof TransferBalanceFCQ) {
            FCMTransactionUtils.addMapKey(mapKeys, body, "getFromShardID", "getFromRealmID", "getFromAccountID");
            FCMTransactionUtils.addMapKey(mapKeys, body, "getToShardID", "getToRealmID", "getToAccountID");
        } else if (!FCMTransactionUtils.isBodyRelatedToNft(body)) {
            FCMTransactionUtils.addMapKey(mapKeys, body, "getShardID", "getRealmID", "getAccountID");
        }
        return mapKeys;
    }

    private static boolean isBodyRelatedToNft(Object body) {
        return body instanceof TransferToken || body instanceof BurnToken || body instanceof MintToken;
    }

    private static void addMapKey(List<MapKey> mapKeys, Object body, String getShardIDStr, String getRealmIDStr, String getAccountIDStr) {
        try {
            Method getShardID = body.getClass().getMethod(getShardIDStr, new Class[0]);
            Method getRealmID = body.getClass().getMethod(getRealmIDStr, new Class[0]);
            Method getAccountID = body.getClass().getMethod(getAccountIDStr, new Class[0]);
            long shardId = (Long)getShardID.invoke(body, new Object[0]);
            long realmId = (Long)getRealmID.invoke(body, new Object[0]);
            long accountId = (Long)getAccountID.invoke(body, new Object[0]);
            mapKeys.add(new MapKey(shardId, realmId, accountId));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Exception when extracting MapKey from FCMTransaction. {}", (Throwable)e);
        }
    }

    public static Object getBodyField(FCMTransaction fcmTransaction) {
        return fcmTransaction.getField(fcmTransaction.getDescriptorForType().findFieldByNumber(fcmTransaction.getBodyCase().getNumber()));
    }

    public static long getNodeId(FCMTransaction fcmTransaction) {
        return fcmTransaction.getOriginNode();
    }
}

