/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.metrics.impl;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.metrics.api.LongAccumulator;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.snapshot.Snapshot;
import com.swirlds.metrics.impl.AbstractMetric;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongBinaryOperator;
import java.util.function.LongSupplier;

public class DefaultLongAccumulator
extends AbstractMetric
implements LongAccumulator {
    private final AtomicLong container;
    private final LongBinaryOperator accumulator;
    private final LongSupplier initializer;

    public DefaultLongAccumulator(@NonNull LongAccumulator.Config config) {
        super((MetricConfig<?, ?>)config);
        long initialValue = config.getInitialValue();
        LongSupplier configInitializer = config.getInitializer();
        this.accumulator = config.getAccumulator();
        this.initializer = configInitializer != null ? configInitializer : () -> initialValue;
        this.container = new AtomicLong(this.initializer.getAsLong());
    }

    public long getInitialValue() {
        return this.initializer.getAsLong();
    }

    @NonNull
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, (Object)this.container.getAndSet(this.initializer.getAsLong())));
    }

    public long get() {
        return this.container.get();
    }

    public void update(long other) {
        this.container.accumulateAndGet(other, this.accumulator);
    }

    @Override
    public void reset() {
        this.container.set(this.initializer.getAsLong());
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("value", (Object)this.get()).toString();
    }
}

