/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.disk;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.merkle.StateUtils;
import com.swirlds.state.merkle.StateValue;
import com.swirlds.state.merkle.disk.OnDiskIterator;
import com.swirlds.state.spi.ReadableKVStateBase;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.Objects;

public final class OnDiskReadableKVState<K, V>
extends ReadableKVStateBase<K, V> {
    @NonNull
    private final VirtualMap virtualMap;
    @NonNull
    private final Codec<K> keyCodec;
    @NonNull
    private final Codec<StateValue<V>> stateValueCodec;

    public OnDiskReadableKVState(int stateId, @NonNull String label, @NonNull Codec<K> keyCodec, @NonNull Codec<V> valueCodec, @NonNull VirtualMap virtualMap) {
        super(stateId, Objects.requireNonNull(label));
        this.keyCodec = Objects.requireNonNull(keyCodec);
        this.stateValueCodec = new StateValue.StateValueCodec<V>(stateId, Objects.requireNonNull(valueCodec));
        this.virtualMap = Objects.requireNonNull(virtualMap);
    }

    protected V readFromDataSource(@NonNull K key) {
        Bytes stateKey = StateUtils.getStateKeyForKv(this.stateId, key, this.keyCodec);
        StateValue stateValue = (StateValue)this.virtualMap.get(stateKey, this.stateValueCodec);
        return stateValue != null ? (V)stateValue.value() : null;
    }

    @NonNull
    protected Iterator<K> iterateFromDataSource() {
        return new OnDiskIterator<K>(this.virtualMap, this.keyCodec, this.stateId);
    }

    @Deprecated
    public long size() {
        return this.virtualMap.size();
    }

    public void warm(@NonNull K key) {
        Bytes stateKey = StateUtils.getStateKeyForKv(this.stateId, key, this.keyCodec);
        this.virtualMap.warm(stateKey);
    }
}

