/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.util.List;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.INTERNAL, since="1.6")
public final class RuntimeUtils {
    private RuntimeUtils() {
    }

    public static boolean isDebugMode() {
        return RuntimeUtils.getInputArguments().map(args -> args.stream().anyMatch(arg -> arg.startsWith("-agentlib:jdwp") || arg.startsWith("-Xrunjdwp"))).orElse(false);
    }

    static Optional<List<String>> getInputArguments() {
        Optional<Class<?>> managementFactoryClass = ReflectionUtils.tryToLoadClass("java.lang.management.ManagementFactory").toOptional();
        if (!managementFactoryClass.isPresent()) {
            return Optional.empty();
        }
        try {
            Object bean = managementFactoryClass.get().getMethod("getRuntimeMXBean", new Class[0]).invoke(null, new Object[0]);
            Class<?> mx = ReflectionUtils.tryToLoadClass("java.lang.management.RuntimeMXBean").get();
            List args = (List)mx.getMethod("getInputArguments", new Class[0]).invoke(bean, new Object[0]);
            return Optional.of(args);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

