/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.editor;

import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.merkle.route.MerkleRouteIterator;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.state.editor.StateEditor;
import com.swirlds.platform.state.editor.StateEditorOperation;
import com.swirlds.platform.state.editor.StateEditorRoot;
import com.swirlds.platform.state.editor.StateEditorUtils;
import com.swirlds.platform.state.signed.ReservedSignedState;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hashable;
import picocli.CommandLine;

@CommandLine.Command(name="load", mixinStandardHelpOptions=true, description={"load a subtree from file and put it into the state"})
@SubcommandOf(value=StateEditorRoot.class)
public class StateEditorLoad
extends StateEditorOperation {
    private static final Logger logger = LogManager.getLogger(StateEditorLoad.class);
    private String destinationPath = "";
    private Path fileName;

    @CommandLine.Parameters(index="0", description={"The location on disk where the subtree should be loaded from."})
    private void setFileName(Path fileName) {
        this.fileName = this.pathMustExist(FileUtils.getAbsolutePath((Path)fileName));
    }

    @CommandLine.Parameters(index="1", arity="0..1", description={"The route where the node should be copied to."})
    private void setDestinationPath(String destinationPath) {
        this.destinationPath = destinationPath;
    }

    @Override
    public void run() {
        MerkleNode subtree;
        StateEditor.ParentInfo parentInfo = this.getStateEditor().getParentInfo(this.destinationPath);
        MerkleRoute destinationRoute = parentInfo.target();
        MerkleInternal parent = parentInfo.parent();
        int indexInParent = parentInfo.indexInParent();
        if (logger.isInfoEnabled(LogMarker.CLI.getMarker())) {
            logger.info(LogMarker.CLI.getMarker(), "Loading subtree from {}", (Object)StateEditorUtils.formatFile(this.fileName));
        }
        try (MerkleDataInputStream in = new MerkleDataInputStream((InputStream)new BufferedInputStream(new FileInputStream(this.fileName.toFile())));){
            subtree = in.readMerkleTree(this.fileName.getParent(), Integer.MAX_VALUE);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (logger.isInfoEnabled(LogMarker.CLI.getMarker())) {
            logger.info(LogMarker.CLI.getMarker(), "Loaded {} subtree into {}, new parent is {}", (Object)StateEditorUtils.formatNodeType(subtree), (Object)StateEditorUtils.formatRoute(destinationRoute), (Object)StateEditorUtils.formatParent((MerkleNode)parent, indexInParent));
        }
        parent.asInternal().setChild(indexInParent, subtree);
        try (ReservedSignedState reservedSignedState = this.getStateEditor().getState("StateEditorLoad.run()");){
            new MerkleRouteIterator(reservedSignedState.get().getState().getRoot(), parent.getRoute()).forEachRemaining(Hashable::invalidateHash);
        }
    }
}

