/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.metrics.PlatformMetricConfig;
import com.swirlds.common.metrics.PlatformMetricsFactory;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricType;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.IntBinaryOperator;
import java.util.function.IntSupplier;

public interface IntegerPairAccumulator<T>
extends Metric {
    public static final BiFunction<Integer, Integer, Double> AVERAGE = (sum, count) -> {
        if (count == 0) {
            return 0.0;
        }
        return (double)sum.intValue() / (double)count.intValue();
    };

    @NonNull
    default public MetricType getMetricType() {
        return MetricType.ACCUMULATOR;
    }

    @NonNull
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return EnumSet.of(Metric.ValueType.VALUE);
    }

    @NonNull
    default public T get(@NonNull Metric.ValueType valueType) {
        Objects.requireNonNull(valueType, "valueType must not be null");
        if (valueType == Metric.ValueType.VALUE) {
            return this.get();
        }
        throw new IllegalArgumentException("Unsupported ValueType: " + String.valueOf(valueType));
    }

    @NonNull
    public T get();

    public int getLeft();

    public int getRight();

    public void update(int var1, int var2);

    public static final class Config<T>
    extends PlatformMetricConfig<IntegerPairAccumulator<T>, Config<T>> {
        @NonNull
        private final Class<T> type;
        @NonNull
        private final BiFunction<Integer, Integer, T> resultFunction;
        @NonNull
        private final IntBinaryOperator leftAccumulator;
        @NonNull
        private final IntBinaryOperator rightAccumulator;
        @NonNull
        private final IntSupplier leftInitializer;
        @NonNull
        private final IntSupplier rightInitializer;
        private static final IntSupplier DEFAULT_INITIALIZER = () -> 0;

        public Config(@NonNull String category, @NonNull String name, @NonNull Class<T> type, @NonNull BiFunction<Integer, Integer, T> resultFunction) {
            super(category, name, "%s");
            this.type = Objects.requireNonNull(type, "type must not be null");
            this.resultFunction = Objects.requireNonNull(resultFunction, "resultFunction must not be null");
            this.leftAccumulator = Integer::sum;
            this.rightAccumulator = Integer::sum;
            this.leftInitializer = DEFAULT_INITIALIZER;
            this.rightInitializer = DEFAULT_INITIALIZER;
        }

        private Config(@NonNull String category, @NonNull String name, @NonNull String description, @NonNull String unit, @NonNull String format, @NonNull Class<T> type, @NonNull BiFunction<Integer, Integer, T> resultFunction, @NonNull IntBinaryOperator leftAccumulator, @NonNull IntBinaryOperator rightAccumulator, @NonNull IntSupplier leftInitializer, @NonNull IntSupplier rightInitializer) {
            super(category, name, description, unit, format);
            this.type = Objects.requireNonNull(type, "type");
            this.resultFunction = Objects.requireNonNull(resultFunction, "resultFunction must not be null");
            this.leftAccumulator = Objects.requireNonNull(leftAccumulator, "leftAccumulator must not be null");
            this.rightAccumulator = Objects.requireNonNull(rightAccumulator, "rightAccumulator must not be null");
            this.leftInitializer = Objects.requireNonNull(leftInitializer, "leftInitializer must not be null");
            this.rightInitializer = Objects.requireNonNull(rightInitializer, "rightInitializer must not be null");
        }

        @NonNull
        public Config<T> withDescription(@NonNull String description) {
            return new Config<T>(this.getCategory(), this.getName(), description, this.getUnit(), this.getFormat(), this.getType(), this.getResultFunction(), this.getLeftAccumulator(), this.getRightAccumulator(), this.getLeftInitializer(), this.getRightInitializer());
        }

        @NonNull
        public Config<T> withUnit(@NonNull String unit) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), unit, this.getFormat(), this.getType(), this.getResultFunction(), this.getLeftAccumulator(), this.getRightAccumulator(), this.getLeftInitializer(), this.getRightInitializer());
        }

        @NonNull
        public Config<T> withFormat(@NonNull String format) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), format, this.getType(), this.getResultFunction(), this.getLeftAccumulator(), this.getRightAccumulator(), this.getLeftInitializer(), this.getRightInitializer());
        }

        @NonNull
        public Class<T> getType() {
            return this.type;
        }

        @NonNull
        public BiFunction<Integer, Integer, T> getResultFunction() {
            return this.resultFunction;
        }

        @NonNull
        public IntBinaryOperator getLeftAccumulator() {
            return this.leftAccumulator;
        }

        @NonNull
        public Config<T> withLeftAccumulator(@NonNull IntBinaryOperator leftAccumulator) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), this.getResultFunction(), leftAccumulator, this.getRightAccumulator(), this.getLeftInitializer(), this.getRightInitializer());
        }

        @NonNull
        public IntBinaryOperator getRightAccumulator() {
            return this.rightAccumulator;
        }

        @NonNull
        public Config<T> withRightAccumulator(@NonNull IntBinaryOperator rightAccumulator) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), this.getResultFunction(), this.getLeftAccumulator(), rightAccumulator, this.getLeftInitializer(), this.getRightInitializer());
        }

        @NonNull
        public IntSupplier getLeftInitializer() {
            return this.leftInitializer;
        }

        @NonNull
        public Config<T> withLeftInitializer(@NonNull IntSupplier leftInitializer) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), this.getResultFunction(), this.getLeftAccumulator(), this.getRightAccumulator(), leftInitializer, this.getRightInitializer());
        }

        @NonNull
        public Config<T> withLeftInitialValue(int leftInitialValue) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), this.getResultFunction(), this.getLeftAccumulator(), this.getRightAccumulator(), leftInitialValue == 0 ? DEFAULT_INITIALIZER : () -> leftInitialValue, this.getRightInitializer());
        }

        @NonNull
        public IntSupplier getRightInitializer() {
            return this.rightInitializer;
        }

        @NonNull
        public Config<T> withRightInitializer(@NonNull IntSupplier rightInitializer) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), this.getResultFunction(), this.getLeftAccumulator(), this.getRightAccumulator(), this.getLeftInitializer(), rightInitializer);
        }

        @NonNull
        public Config<T> withRightInitialValue(int rightInitialValue) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), this.getResultFunction(), this.getLeftAccumulator(), this.getRightAccumulator(), this.getLeftInitializer(), rightInitialValue == 0 ? DEFAULT_INITIALIZER : () -> rightInitialValue);
        }

        @NonNull
        public Class<IntegerPairAccumulator<T>> getResultClass() {
            return IntegerPairAccumulator.class;
        }

        @Override
        @NonNull
        public IntegerPairAccumulator<T> create(@NonNull PlatformMetricsFactory factory) {
            return factory.createIntegerPairAccumulator(this);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("type", (Object)this.type.getName()).toString();
        }
    }
}

