/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.token.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class NftJsonCodec
implements JsonCodec<Nft> {
    @NonNull
    public Nft parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            NftID temp_nft_id = null;
            AccountID temp_owner_id = null;
            AccountID temp_spender_id = null;
            Timestamp temp_mint_time = null;
            Bytes temp_metadata = Bytes.EMPTY;
            NftID temp_owner_previous_nft_id = null;
            NftID temp_owner_next_nft_id = null;
            block20: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "nftId": {
                        temp_nft_id = (NftID)NftID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block20;
                    }
                    case "ownerId": {
                        temp_owner_id = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block20;
                    }
                    case "spenderId": {
                        temp_spender_id = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block20;
                    }
                    case "mintTime": {
                        temp_mint_time = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block20;
                    }
                    case "metadata": {
                        temp_metadata = Bytes.fromBase64((String)JsonTools.checkSize((String)"metadata", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block20;
                    }
                    case "ownerPreviousNftId": {
                        temp_owner_previous_nft_id = (NftID)NftID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block20;
                    }
                    case "ownerNextNftId": {
                        temp_owner_next_nft_id = (NftID)NftID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block20;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new Nft(temp_nft_id, temp_owner_id, temp_spender_id, temp_mint_time, temp_metadata, temp_owner_previous_nft_id, temp_owner_next_nft_id);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull Nft data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.nftId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"nftId", NftID.JSON, (Object)data.nftId()));
        }
        if (data.ownerId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"ownerId", AccountID.JSON, (Object)data.ownerId()));
        }
        if (data.spenderId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"spenderId", AccountID.JSON, (Object)data.spenderId()));
        }
        if (data.mintTime() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"mintTime", Timestamp.JSON, (Object)data.mintTime()));
        }
        if (data.metadata() != Bytes.EMPTY && data.metadata() != null && data.metadata().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"metadata", (Bytes)data.metadata()));
        }
        if (data.ownerPreviousNftId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"ownerPreviousNftId", NftID.JSON, (Object)data.ownerPreviousNftId()));
        }
        if (data.ownerNextNftId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"ownerNextNftId", NftID.JSON, (Object)data.ownerNextNftId()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

