/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.crypto.engine;

import com.swirlds.logging.legacy.LogMarker;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.CryptographyException;
import org.hiero.base.crypto.SignatureType;
import org.hiero.base.crypto.TransactionSignature;
import org.hiero.base.crypto.engine.CachingOperationProvider;
import org.hiero.base.crypto.engine.EcdsaSecp256k1Verifier;
import org.hiero.base.utility.CommonUtils;

public class EcdsaSecp256k1VerificationProvider
extends CachingOperationProvider<TransactionSignature, Void, Boolean, EcdsaSecp256k1Verifier, SignatureType> {
    private static final Logger logger = LogManager.getLogger(EcdsaSecp256k1VerificationProvider.class);

    protected boolean compute(byte[] message, byte[] signature, byte[] publicKey, SignatureType algorithmType) {
        EcdsaSecp256k1Verifier loadedAlgorithm;
        try {
            loadedAlgorithm = (EcdsaSecp256k1Verifier)this.loadAlgorithm(algorithmType);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e, LogMarker.ERROR);
        }
        return this.verified(loadedAlgorithm, algorithmType, message, signature, publicKey);
    }

    @Override
    protected EcdsaSecp256k1Verifier handleAlgorithmRequired(SignatureType algorithmType) throws NoSuchAlgorithmException {
        return new EcdsaSecp256k1Verifier();
    }

    @Override
    protected Boolean handleItem(EcdsaSecp256k1Verifier algorithm, SignatureType algorithmType, TransactionSignature sig, Void optionalData) {
        return this.verified(algorithm, algorithmType, sig.getMessage().toByteArray(), sig.getSignature().toByteArray(), sig.getPublicKey().toByteArray());
    }

    private boolean verified(EcdsaSecp256k1Verifier algorithm, SignatureType algorithmType, byte[] message, byte[] signature, byte[] publicKey) {
        boolean isValid = algorithm.verify(signature, message, publicKey);
        if (!isValid && logger.isDebugEnabled()) {
            logger.debug(LogMarker.TESTING_EXCEPTIONS.getMarker(), "Adv Crypto Subsystem: Signature Verification Failure for signature type {} [ publicKey = {}, signature = {} ]", (Object)algorithmType, (Object)CommonUtils.hex((byte[])publicKey), (Object)CommonUtils.hex((byte[])signature));
        }
        return isValid;
    }
}

