/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.cli.utils;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.metrics.noop.NoOpMetrics;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.snapshot.DeserializedSignedState;
import com.swirlds.platform.system.SwirldMain;
import com.swirlds.state.MerkleNodeState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.hiero.base.crypto.Hash;

public class HederaUtils {
    public static final String HEDERA_MAIN_CLASS = "com.hedera.node.app.ServicesMain";
    public static final String SWIRLD_NAME = "123";

    public static SwirldMain<? extends MerkleNodeState> createHederaAppMain(@NonNull PlatformContext platformContext, @NonNull PlatformStateFacade platformStateFacade) {
        try {
            Class<?> mainClass = Class.forName(HEDERA_MAIN_CLASS);
            Method newHederaMethod = mainClass.getDeclaredMethod("newHedera", Metrics.class, PlatformStateFacade.class, Configuration.class);
            return (SwirldMain)newHederaMethod.invoke(null, new NoOpMetrics(), platformStateFacade, platformContext.getConfiguration());
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void updateStateHash(@NonNull SwirldMain<? extends MerkleNodeState> hederaApp, @NonNull DeserializedSignedState deserializedSignedState) {
        try {
            Method setInitialStateHash = hederaApp.getClass().getDeclaredMethod("setInitialStateHash", Hash.class);
            setInitialStateHash.invoke(hederaApp, deserializedSignedState.originalHash());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

