/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.event.preconsensus;

import com.swirlds.platform.event.preconsensus.PcesFile;
import com.swirlds.platform.event.preconsensus.PcesFileVersion;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public final class PcesTestFilesGenerator {
    public static final Range FIRST_SEQUENCE_RANGE = new Range(950, 1000);
    public static final Range MAX_DELTA_RANGE = new Range(10, 20);
    public static final Range LOWERBOUND_RANGE = new Range(0, 1000);
    public static final Range TIMESTAP_RANGE = new Range(1, 100000);
    public static final int DEFAULT_NUM_FILES_TO_GENERATE = 100;
    private final Range startingOriginRange;
    private final Random rng;
    private final int numFilesToGenerate;
    private final Path fileDirectory;
    private final boolean skipAtStart;
    private final boolean discontinue;
    private final boolean skipElementAtHalf;
    private final Predicate<Integer> shouldAdvanceBoundsPredicate;

    private PcesTestFilesGenerator(@Nullable Range startingOriginRange, @NonNull Random rng, int numFilesToGenerate, @NonNull Path fileDirectory, boolean skipAtStart, boolean discontinue, boolean skipElementAtHalf, @Nullable Predicate<Integer> shouldAdvanceBoundsPredicate) {
        this.startingOriginRange = startingOriginRange;
        this.rng = rng;
        this.numFilesToGenerate = numFilesToGenerate;
        this.fileDirectory = fileDirectory;
        this.skipAtStart = skipAtStart;
        this.discontinue = discontinue;
        this.skipElementAtHalf = skipElementAtHalf;
        this.shouldAdvanceBoundsPredicate = shouldAdvanceBoundsPredicate;
    }

    private static void createDummyPcesFile(@NonNull PcesFile descriptor) throws IOException {
        Path parentDir = descriptor.getPath().getParent();
        if (!Files.exists(parentDir, new LinkOption[0])) {
            Files.createDirectories(parentDir, new FileAttribute[0]);
        }
        SerializableDataOutputStream out = new SerializableDataOutputStream((OutputStream)new FileOutputStream(descriptor.getPath().toFile()));
        out.writeInt(PcesFileVersion.currentVersionNumber());
        out.writeNormalisedString("foo bar baz");
        out.close();
    }

    @NonNull
    public PcesFilesGeneratorResult generate() throws IOException {
        long originStartValue;
        int firstSequenceNumber = this.getIntFromRange(FIRST_SEQUENCE_RANGE);
        int maxDelta = this.getIntFromRange(MAX_DELTA_RANGE);
        long lowerBound = this.getLongFromRange(LOWERBOUND_RANGE);
        long upperBound = lowerBound + (long)this.rng.nextInt(2, maxDelta);
        long nonExistentValue = lowerBound + 1L;
        long halfIndex = this.numFilesToGenerate / 2;
        if ((this.discontinue || this.skipAtStart) && this.numFilesToGenerate < 5) {
            throw new IllegalArgumentException("if discontinue or skipStart is set the minimum files to generate is 5");
        }
        int startIndexIfSkip = this.discontinue || this.skipAtStart ? this.rng.nextInt(2, this.numFilesToGenerate - 2) : 0;
        int discontinuityIndex = this.rng.nextInt(startIndexIfSkip, this.numFilesToGenerate);
        Instant timestamp = Instant.now();
        long originCurrentValue = originStartValue = this.startingOriginRange != null ? this.getLongFromRange(this.startingOriginRange) : 0L;
        ArrayList<PcesFile> filesBeforeDiscontinuity = new ArrayList<PcesFile>();
        ArrayList<PcesFile> filesAfterDiscontinuity = new ArrayList<PcesFile>();
        ArrayList<PcesFile> files = new ArrayList<PcesFile>();
        for (int index = 0; index < this.numFilesToGenerate; ++index) {
            boolean isPreDiscontinuity;
            long sequenceNumber = firstSequenceNumber + index;
            boolean bl = isPreDiscontinuity = index < discontinuityIndex;
            if (this.discontinue && index == discontinuityIndex) {
                originCurrentValue += (long)this.getIntFromRange(MAX_DELTA_RANGE);
            }
            PcesFile file = PcesFile.of((Instant)timestamp, (long)sequenceNumber, (long)lowerBound, (long)upperBound, (long)originCurrentValue, (Path)this.fileDirectory);
            if (this.shouldAdvanceBoundsPredicate == null || this.shouldAdvanceBoundsPredicate.test(index)) {
                lowerBound = this.rng.nextLong(lowerBound + 1L, upperBound + 1L);
                upperBound += (long)this.rng.nextInt(1, maxDelta);
            }
            timestamp = timestamp.plusMillis(this.getIntFromRange(TIMESTAP_RANGE));
            if (this.skipElementAtHalf && (long)index == halfIndex || this.skipAtStart && index < startIndexIfSkip) continue;
            files.add(file);
            PcesTestFilesGenerator.createDummyPcesFile(file);
            if (!this.discontinue) continue;
            if (isPreDiscontinuity) {
                filesBeforeDiscontinuity.add(file);
                continue;
            }
            filesAfterDiscontinuity.add(file);
        }
        long afterUnbrokenOrigin = this.discontinue ? this.rng.nextLong(originCurrentValue + 1L, originCurrentValue + 1000L) : -1L;
        long beforeUnbrokenOrigin = this.discontinue ? this.rng.nextLong(originStartValue, originCurrentValue) : -1L;
        return new PcesFilesGeneratorResult(filesBeforeDiscontinuity, filesAfterDiscontinuity, files, originStartValue, originCurrentValue, nonExistentValue, afterUnbrokenOrigin, beforeUnbrokenOrigin);
    }

    private long getLongFromRange(@NonNull Range range) {
        return this.rng.nextLong(range.start(), range.end());
    }

    private int getIntFromRange(@NonNull Range range) {
        return this.rng.nextInt(range.start(), range.end());
    }

    public record Range(int start, int end) {
    }

    public record PcesFilesGeneratorResult(@NonNull List<PcesFile> filesBeforeDiscontinuity, @NonNull List<PcesFile> filesAfterDiscontinuity, @NonNull List<PcesFile> files, long startUnbrokenOrigin, long resultingUnbrokenOrigin, long nonExistentValue, long pointAfterUnbrokenOrigin, long pointBeforeUnbrokenOrigin) {
    }

    public static class Builder {
        private final Random rng;
        private final Path fileDirectory;
        private Range originRange = null;
        private boolean ignoreSome;
        private boolean skipElementAtHalf;
        private boolean discontinue;
        private Predicate<Integer> shouldAdvanceBoundsPredicate;
        private Integer numFilesToGenerate = 100;

        private Builder(@NonNull Random rng, @NonNull Path fileDirectory) {
            this.rng = rng;
            this.fileDirectory = fileDirectory;
        }

        @NonNull
        public static Builder create(@NonNull Random rng, @NonNull Path fileDirectory) {
            return new Builder(rng, fileDirectory);
        }

        @NonNull
        public Builder discontinue() {
            this.discontinue = true;
            return this;
        }

        @NonNull
        public Builder introduceGapHalfway() {
            this.skipElementAtHalf = true;
            return this;
        }

        @NonNull
        public Builder skipAtStart() {
            this.ignoreSome = true;
            return this;
        }

        @NonNull
        public Builder withOriginRange(@NonNull Range range) {
            this.originRange = range;
            return this;
        }

        @NonNull
        public Builder withAdvanceBoundsStrategy(@NonNull Predicate<Integer> shouldAdvanceBoundsPredicate) {
            this.shouldAdvanceBoundsPredicate = shouldAdvanceBoundsPredicate;
            return this;
        }

        @NonNull
        public Builder withNumFilesToGenerate(@NonNull Integer numFilesToGenerate) {
            if (numFilesToGenerate <= 0) {
                throw new IllegalArgumentException("numFilesToGenerate should be higher than 0");
            }
            this.numFilesToGenerate = numFilesToGenerate;
            return this;
        }

        @NonNull
        public PcesTestFilesGenerator build() {
            return new PcesTestFilesGenerator(this.originRange, this.rng, this.numFilesToGenerate, this.fileDirectory, this.ignoreSome, this.discontinue, this.skipElementAtHalf, this.shouldAdvanceBoundsPredicate);
        }
    }
}

