/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.base.internal;

import com.swirlds.base.internal.impl.BaseExecutorFactoryImpl;
import com.swirlds.base.internal.impl.BaseScheduledExecutorService;
import com.swirlds.base.internal.observe.BaseExecutorObserver;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public interface BaseExecutorFactory {
    @NonNull
    public ScheduledExecutorService getScheduledExecutor();

    @NonNull
    default public Future<Void> submit(@NonNull Runnable task) {
        return this.getScheduledExecutor().submit(task, null);
    }

    @NonNull
    default public <V> Future<V> submit(@NonNull Callable<V> task) {
        return this.getScheduledExecutor().submit(task);
    }

    @NonNull
    default public ScheduledFuture<Void> scheduleAtFixedRate(@NonNull Runnable task, long initialDelay, long period, @NonNull TimeUnit unit) {
        ScheduledFuture<?> scheduledFuture = this.getScheduledExecutor().scheduleAtFixedRate(task, initialDelay, period, unit);
        return BaseExecutorFactory.wrap(scheduledFuture);
    }

    @NonNull
    default public ScheduledFuture<Void> schedule(@NonNull Runnable command, long delay, @NonNull TimeUnit unit) {
        ScheduledFuture<?> scheduledFuture = this.getScheduledExecutor().schedule(command, delay, unit);
        return BaseExecutorFactory.wrap(scheduledFuture);
    }

    @NonNull
    private static ScheduledFuture<Void> wrap(final @NonNull ScheduledFuture<?> scheduledFuture) {
        return new ScheduledFuture<Void>(){

            @Override
            public long getDelay(TimeUnit unit) {
                return scheduledFuture.getDelay(unit);
            }

            @Override
            public int compareTo(Delayed o) {
                return scheduledFuture.compareTo(o);
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return scheduledFuture.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return scheduledFuture.isCancelled();
            }

            @Override
            public boolean isDone() {
                return scheduledFuture.isDone();
            }

            @Override
            public Void get() throws InterruptedException, ExecutionException {
                scheduledFuture.get();
                return null;
            }

            @Override
            public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                scheduledFuture.get(timeout, unit);
                return null;
            }
        };
    }

    @NonNull
    public static BaseExecutorFactory getInstance() {
        return BaseExecutorFactoryImpl.getInstance();
    }

    public static void addObserver(@NonNull BaseExecutorObserver observer) {
        BaseScheduledExecutorService.getInstance().addObserver(observer);
    }

    public static void removeObserver(@NonNull BaseExecutorObserver observer) {
        BaseScheduledExecutorService.getInstance().removeObserver(observer);
    }
}

