/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.roster;

import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterState;
import com.hedera.hapi.node.state.roster.RoundRosterPair;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.hiero.consensus.roster.ReadableRosterStore;
import org.hiero.consensus.roster.RosterStateId;

public class ReadableRosterStoreImpl
implements ReadableRosterStore {
    private final ReadableSingletonState<RosterState> rosterState;
    private final ReadableKVState<ProtoBytes, Roster> rosterMap;

    public ReadableRosterStoreImpl(@NonNull ReadableStates readableStates) {
        Objects.requireNonNull(readableStates);
        this.rosterState = readableStates.getSingleton(RosterStateId.ROSTER_STATE_STATE_ID);
        this.rosterMap = readableStates.get(RosterStateId.ROSTERS_STATE_ID);
    }

    @Override
    @Nullable
    public Roster getCandidateRoster() {
        RosterState rosterStateSingleton = (RosterState)this.rosterState.get();
        if (rosterStateSingleton == null) {
            return null;
        }
        Bytes candidateRosterHash = rosterStateSingleton.candidateRosterHash();
        return (Roster)this.rosterMap.get((Object)ProtoBytes.newBuilder().value(candidateRosterHash).build());
    }

    @Override
    @Nullable
    public Roster getActiveRoster() {
        Bytes activeRosterHash = this.getCurrentRosterHash();
        if (activeRosterHash == null) {
            return null;
        }
        return (Roster)this.rosterMap.get((Object)ProtoBytes.newBuilder().value(activeRosterHash).build());
    }

    @Override
    @Nullable
    public Roster get(@NonNull Bytes rosterHash) {
        return (Roster)this.rosterMap.get((Object)ProtoBytes.newBuilder().value(rosterHash).build());
    }

    @Override
    @Nullable
    public Bytes getCurrentRosterHash() {
        RosterState rosterStateSingleton = (RosterState)this.rosterState.get();
        if (rosterStateSingleton == null) {
            return null;
        }
        List rostersAndRounds = rosterStateSingleton.roundRosterPairs();
        if (rostersAndRounds.isEmpty()) {
            return null;
        }
        RoundRosterPair latestRoundRosterPair = (RoundRosterPair)rostersAndRounds.getFirst();
        return latestRoundRosterPair.activeRosterHash();
    }

    @Override
    @Nullable
    public Bytes getPreviousRosterHash() {
        List<RoundRosterPair> rosterHistory = this.getRosterHistory();
        return rosterHistory.size() > 1 ? rosterHistory.get(1).activeRosterHash() : null;
    }

    @Override
    @NonNull
    public List<RoundRosterPair> getRosterHistory() {
        return Objects.requireNonNull((RosterState)this.rosterState.get()).roundRosterPairs().stream().filter(pair -> this.rosterMap.contains((Object)new ProtoBytes(pair.activeRosterHash()))).toList();
    }

    @Override
    @Nullable
    public Bytes getCandidateRosterHash() {
        return Optional.ofNullable((RosterState)this.rosterState.get()).map(RosterState::candidateRosterHash).filter(bytes -> bytes.length() > 0L).orElse(null);
    }

    @Override
    public boolean isTransplantInProgress() {
        return this.rosterState.get() != null && Objects.requireNonNull((RosterState)this.rosterState.get()).transplantInProgress();
    }
}

