/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.system;

import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.platform.system.PlatformMonitor;
import com.swirlds.platform.system.status.StatusStateMachine;
import com.swirlds.platform.system.status.actions.CatastrophicFailureAction;
import com.swirlds.platform.system.status.actions.PlatformStatusAction;
import com.swirlds.platform.system.status.actions.SelfEventReachedConsensusAction;
import com.swirlds.platform.system.status.actions.StateWrittenToDiskAction;
import com.swirlds.platform.system.status.actions.TimeElapsedAction;
import com.swirlds.platform.uptime.UptimeTracker;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.hiero.consensus.model.hashgraph.ConsensusRound;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.notification.IssNotification;
import org.hiero.consensus.model.quiescence.QuiescenceCommand;
import org.hiero.consensus.model.state.StateSavingResult;
import org.hiero.consensus.model.status.PlatformStatus;

public class DefaultPlatformMonitor
implements PlatformMonitor {
    private static final Set<IssNotification.IssType> CATASTROPHIC_ISS_TYPES = Set.of(IssNotification.IssType.SELF_ISS, IssNotification.IssType.CATASTROPHIC_ISS);
    private final Time time;
    private final StatusStateMachine statusStateMachine;
    private final UptimeTracker uptimeTracker;
    private QuiescenceCommand lastQuiescenceCommand;
    private Instant lastQuiescenceCommandTime;

    public DefaultPlatformMonitor(@NonNull PlatformContext platformContext, @NonNull NodeId selfId) {
        this.time = platformContext.getTime();
        this.statusStateMachine = new StatusStateMachine(platformContext);
        this.uptimeTracker = new UptimeTracker(platformContext, selfId);
        this.lastQuiescenceCommand = QuiescenceCommand.DONT_QUIESCE;
        this.lastQuiescenceCommandTime = this.time.now();
    }

    @Override
    @Nullable
    public PlatformStatus submitStatusAction(@NonNull PlatformStatusAction action) {
        return this.statusStateMachine.submitStatusAction(action);
    }

    @Override
    public PlatformStatus heartbeat(@NonNull Instant time) {
        return this.statusStateMachine.submitStatusAction(new TimeElapsedAction(time, new TimeElapsedAction.QuiescingStatus(this.lastQuiescenceCommand == QuiescenceCommand.QUIESCE, this.lastQuiescenceCommandTime)));
    }

    @Override
    public PlatformStatus consensusRound(@NonNull ConsensusRound round) {
        boolean selfEventReachedConsensus = this.uptimeTracker.trackRound(round);
        if (!selfEventReachedConsensus) {
            return null;
        }
        return this.statusStateMachine.submitStatusAction(new SelfEventReachedConsensusAction(this.time.now()));
    }

    @Override
    public void quiescenceCommand(@NonNull QuiescenceCommand command) {
        if (this.lastQuiescenceCommand != Objects.requireNonNull(command)) {
            this.lastQuiescenceCommand = command;
            this.lastQuiescenceCommandTime = this.time.now();
        }
    }

    @Override
    public PlatformStatus stateWrittenToDisk(@NonNull StateSavingResult result) {
        return this.statusStateMachine.submitStatusAction(new StateWrittenToDiskAction(result.round(), result.freezeState()));
    }

    @Override
    @Nullable
    public PlatformStatus issNotification(@NonNull List<IssNotification> notifications) {
        if (notifications.stream().map(IssNotification::getIssType).anyMatch(CATASTROPHIC_ISS_TYPES::contains)) {
            return this.statusStateMachine.submitStatusAction(new CatastrophicFailureAction());
        }
        return null;
    }
}

