/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Objects;

public class StateKeyUtils {
    private static final int FIELD_NUM_SINGLETON = 1;

    private StateKeyUtils() {
    }

    public static Bytes singletonKey(int stateId) {
        Bytes bytes;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            WritableStreamingData out = new WritableStreamingData((OutputStream)bout);
            out.writeVarInt(8 | ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG.ordinal(), false);
            out.writeVarInt(stateId, false);
            bytes = Bytes.wrap((byte[])bout.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    bout.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        bout.close();
        return bytes;
    }

    public static Bytes queueKey(int stateId, long index) {
        Bytes bytes;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            WritableStreamingData out = new WritableStreamingData((OutputStream)bout);
            out.writeVarInt(stateId << 3 | ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG.ordinal(), false);
            out.writeVarLong(index, false);
            bytes = Bytes.wrap((byte[])bout.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    bout.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        bout.close();
        return bytes;
    }

    public static Bytes queueStateKey(int stateId) {
        return StateKeyUtils.singletonKey(stateId);
    }

    public static <K> Bytes kvKey(int stateId, K key, Codec<K> keyCodec) {
        Bytes bytes;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            WritableStreamingData out = new WritableStreamingData((OutputStream)bout);
            out.writeVarInt(stateId << 3 | ProtoConstants.WIRE_TYPE_DELIMITED.ordinal(), false);
            out.writeVarInt(keyCodec.measureRecord(key), false);
            keyCodec.write(key, (WritableSequentialData)out);
            bytes = Bytes.wrap((byte[])bout.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    bout.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        bout.close();
        return bytes;
    }

    public static Bytes kvKey(int stateId, Bytes key) {
        Bytes bytes;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            WritableStreamingData out = new WritableStreamingData((OutputStream)bout);
            out.writeVarInt(stateId << 3 | ProtoConstants.WIRE_TYPE_DELIMITED.ordinal(), false);
            out.writeVarInt(StrictMath.toIntExact(key.length()), false);
            out.writeBytes((RandomAccessData)key);
            bytes = Bytes.wrap((byte[])bout.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    bout.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        bout.close();
        return bytes;
    }

    public static int extractStateIdFromStateKeyOneOf(@NonNull Bytes stateKey) {
        Objects.requireNonNull(stateKey, "Null state key");
        return ProtoParserTools.readNextFieldNumber((ReadableSequentialData)stateKey.toReadableSequentialData());
    }

    public static <K> K extractKeyFromStateKeyOneOf(@NonNull Bytes stateKey, @NonNull Codec<K> keyCodec) throws ParseException {
        Objects.requireNonNull(stateKey, "Null state key");
        Objects.requireNonNull(keyCodec, "Null key codec");
        ReadableSequentialData in = stateKey.toReadableSequentialData();
        int tag = in.readVarInt(false);
        assert (tag >> 3 == StateKeyUtils.extractStateIdFromStateKeyOneOf(stateKey));
        assert (tag >> 3 != 1);
        int size = in.readVarInt(false);
        assert (in.position() + (long)size == stateKey.length());
        return (K)keyCodec.parse(in);
    }
}

