/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.metrics.api.snapshot;

import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.snapshot.SnapshotableMetric;
import java.util.List;
import java.util.Objects;

public record Snapshot(Metric metric, List<SnapshotEntry> entries) {
    public static Snapshot of(SnapshotableMetric metric) {
        Objects.requireNonNull(metric, "metric must not be null");
        return new Snapshot(metric, metric.takeSnapshot());
    }

    public Object getValue() {
        for (SnapshotEntry entry : this.entries) {
            if (entry.valueType != Metric.ValueType.VALUE) continue;
            return entry.value;
        }
        throw new IllegalStateException("Snapshot does not contain a value: " + String.valueOf(this));
    }

    public record SnapshotEntry(Metric.ValueType valueType, Object value) {
    }
}

