/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.platform.state.codec;

import com.hedera.hapi.platform.state.JudgeId;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class JudgeIdJsonCodec
implements JsonCodec<JudgeId> {
    @NonNull
    public JudgeId parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            long temp_creator_id = 0L;
            Bytes temp_judge_hash = Bytes.EMPTY;
            block10: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "creatorId": {
                        temp_creator_id = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block10;
                    }
                    case "judgeHash": {
                        temp_judge_hash = Bytes.fromBase64((String)JsonTools.checkSize((String)"judge_hash", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block10;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new JudgeId(temp_creator_id, temp_judge_hash);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull JudgeId data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.creatorId() != 0L) {
            fieldLines.add(JsonTools.field((String)"creatorId", (long)data.creatorId()));
        }
        if (data.judgeHash() != Bytes.EMPTY && data.judgeHash() != null && data.judgeHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"judgeHash", (Bytes)data.judgeHash()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

