/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.event.source;

import com.swirlds.common.test.fixtures.TransactionGenerator;
import com.swirlds.platform.internal.EventImpl;
import com.swirlds.platform.test.fixtures.event.DynamicValue;
import com.swirlds.platform.test.fixtures.event.EventUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Random;
import org.hiero.consensus.model.node.NodeId;

public interface EventSource {
    public EventSource copy();

    public void reset();

    @NonNull
    public NodeId getNodeId();

    public EventSource setNodeId(@NonNull NodeId var1);

    public double getNewEventWeight(Random var1, long var2);

    default public EventSource setNewEventWeight(double newEventWeight) {
        this.setNewEventWeight(EventUtils.staticDynamicValue(newEventWeight));
        return this;
    }

    public void setNewEventWeight(DynamicValue<Double> var1);

    public EventSource setTransactionGenerator(TransactionGenerator var1);

    public EventImpl generateEvent(@NonNull Random var1, long var2, @Nullable EventSource var4, @NonNull Instant var5, long var6);

    public EventImpl getRecentEvent(Random var1, int var2);

    default public EventImpl getLatestEvent(Random random) {
        return this.getRecentEvent(random, 0);
    }

    public void setLatestEvent(Random var1, EventImpl var2);

    public int getRequestedOtherParentAge(Random var1, long var2);

    public EventSource setRequestedOtherParentAgeDistribution(DynamicValue<Integer> var1);

    public int getProvidedOtherParentAge(Random var1, long var2);

    public EventSource setProvidedOtherParentAgeDistribution(DynamicValue<Integer> var1);

    public int getRecentEventRetentionSize();

    public EventSource setRecentEventRetentionSize(int var1);
}

