/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.test.fixtures.merkle.memory;

import com.hedera.pbj.runtime.Codec;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.impl.PartialMerkleLeaf;
import com.swirlds.common.merkle.utility.Keyed;
import com.swirlds.state.merkle.StateUtils;
import com.swirlds.state.test.fixtures.merkle.memory.InMemoryKey;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public final class InMemoryValue<K, V>
extends PartialMerkleLeaf
implements MerkleNode,
Keyed<InMemoryKey<K>>,
SelfSerializable,
MerkleLeaf {
    @Deprecated(forRemoval=true)
    private static final long CLASS_ID = 456913269007202088L;
    private InMemoryKey<K> key;
    private final Codec<K> keyCodec;
    private final Codec<V> valueCodec;
    private final long classId;
    private V val;

    @Deprecated(forRemoval=true)
    public InMemoryValue() {
        this.classId = 456913269007202088L;
        this.keyCodec = null;
        this.valueCodec = null;
    }

    public InMemoryValue(long classId, @Nullable Codec<K> keyCodec, @NonNull Codec<V> valueCodec) {
        this.classId = classId;
        this.keyCodec = keyCodec;
        this.valueCodec = valueCodec;
    }

    public InMemoryValue(long classId, @Nullable Codec<K> keyCodec, @NonNull Codec<V> valueCodec, @NonNull InMemoryKey<K> key, @NonNull V value) {
        this(classId, keyCodec, valueCodec);
        this.key = Objects.requireNonNull(key);
        this.val = Objects.requireNonNull(value);
    }

    public InMemoryValue<K, V> copy() {
        this.throwIfImmutable();
        this.throwIfDestroyed();
        InMemoryValue<K, V> cp = new InMemoryValue<K, V>(this.classId, this.keyCodec, this.valueCodec, this.key, this.val);
        this.setImmutable(true);
        return cp;
    }

    public long getClassId() {
        return this.classId;
    }

    public int getVersion() {
        return 1;
    }

    public InMemoryKey<K> getKey() {
        return this.key;
    }

    public void setKey(@NonNull InMemoryKey<K> inMemoryKey) {
        this.throwIfImmutable();
        this.key = Objects.requireNonNull(inMemoryKey);
    }

    @Nullable
    public V getValue() {
        return this.val;
    }

    public void setValue(@Nullable V value) {
        this.throwIfImmutable();
        this.val = value;
    }

    public void deserialize(@NonNull SerializableDataInputStream in, int ignored) throws IOException {
        assert (this.keyCodec != null);
        Object k = StateUtils.readFromStream((InputStream)in, this.keyCodec);
        this.key = new InMemoryKey<Object>(k);
        this.val = StateUtils.readFromStream((InputStream)in, this.valueCodec);
    }

    public void serialize(@NonNull SerializableDataOutputStream out) throws IOException {
        StateUtils.writeToStream((OutputStream)out, this.keyCodec, this.key.key());
        StateUtils.writeToStream((OutputStream)out, this.valueCodec, this.val);
    }
}

