/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.collections;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;

public final class Iterables {
    public static <T> Iterable<T> toIterable(Enumeration<T> in) {
        ArrayList<T> out = new ArrayList<T>();
        while (in.hasMoreElements()) {
            out.add(in.nextElement());
        }
        return out;
    }

    public static <T> T firstOf(Iterable<T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("Cannot provide 1st element from empty iterable: " + String.valueOf(iterable));
        }
        return iterator.next();
    }

    private Iterables() {
    }
}

