/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.health;

import com.swirlds.common.formatting.StringFormattingUtils;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.health.OSHealthCheck;
import com.swirlds.platform.health.OSHealthCheckConfig;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class OSHealthChecker {
    private static final Logger logger = LogManager.getLogger(OSHealthChecker.class);

    private OSHealthChecker() {
    }

    public static void performOSHealthChecks(OSHealthCheckConfig osHealthConfig, Iterable<OSHealthCheck> healthChecks) {
        StringBuilder sb = new StringBuilder();
        boolean allPassed = true;
        long start = System.nanoTime();
        for (OSHealthCheck check : healthChecks) {
            allPassed &= check.performCheckAndReport(sb, osHealthConfig);
        }
        long end = System.nanoTime();
        sb.append(System.lineSeparator());
        StringFormattingUtils.addLine((StringBuilder)sb, (String)String.format("OS Health Check Report - Complete (took %d ms)", TimeUnit.NANOSECONDS.toMillis(end - start)));
        if (allPassed) {
            logger.info(LogMarker.STARTUP.getMarker(), (CharSequence)sb);
        } else {
            logger.warn(LogMarker.STARTUP.getMarker(), (CharSequence)sb);
        }
    }
}

