/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.crypto;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.utility.ToStringBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Objects;
import org.hiero.base.crypto.SignatureType;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class Signature {
    private static final long CLASS_ID = 1431101492385045609L;
    private static final int CLASS_VERSION = 1;
    private final SignatureType signatureType;
    private final Bytes signatureBytes;

    public Signature(@NonNull SignatureType signatureType, @NonNull byte[] signatureBytes) {
        this(signatureType, Bytes.wrap((byte[])signatureBytes));
    }

    public Signature(@NonNull SignatureType signatureType, @NonNull Bytes signatureBytes) {
        this.signatureType = Objects.requireNonNull(signatureType, "signatureType should not be null");
        this.signatureBytes = Objects.requireNonNull(signatureBytes, "signatureBytes should not be null");
    }

    @NonNull
    public Bytes getBytes() {
        return this.signatureBytes;
    }

    @NonNull
    public SignatureType getType() {
        return this.signatureType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Signature)) {
            return false;
        }
        Signature signature = (Signature)obj;
        return Objects.equals(this.signatureBytes, signature.signatureBytes) && this.signatureType == signature.signatureType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signatureType, this.signatureBytes});
    }

    public static Signature deserialize(SerializableDataInputStream in, boolean readClassId) throws IOException {
        long classId;
        if (readClassId && (classId = in.readLong()) != 1431101492385045609L) {
            throw new IOException("unexpected class ID: " + classId);
        }
        in.readInt();
        SignatureType signatureType = SignatureType.from(in.readInt(), SignatureType.RSA);
        byte[] signatureBytes = in.readByteArray(signatureType.signatureLength(), true);
        return new Signature(signatureType, signatureBytes);
    }

    public void serialize(SerializableDataOutputStream out, boolean withClassId) throws IOException {
        if (withClassId) {
            out.writeLong(1431101492385045609L);
        }
        out.writeInt(1);
        out.writeInt(this.signatureType.ordinal());
        out.writeByteArray(this.signatureBytes.toByteArray(), true);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("signatureType", (Object)this.signatureType).append("sigBytes", (Object)this.signatureBytes).toString();
    }
}

