/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.wiring.components;

import com.swirlds.component.framework.component.ComponentWiring;
import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerConfiguration;
import com.swirlds.component.framework.wires.input.InputWire;
import com.swirlds.component.framework.wires.output.OutputWire;
import com.swirlds.platform.components.consensus.ConsensusEngine;
import com.swirlds.platform.components.consensus.ConsensusEngineOutput;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.hiero.consensus.model.hashgraph.ConsensusRound;

public record ConsensusWiring(@NonNull ComponentWiring<ConsensusEngine, ConsensusEngineOutput> componentWiring, @NonNull OutputWire<List<ConsensusRound>> consensusRoundsOutputWire) {
    @NonNull
    public static ConsensusWiring create(@NonNull WiringModel model, @NonNull TaskSchedulerConfiguration consensusEngineConfig) {
        ComponentWiring consensusEngineWiring = new ComponentWiring(model, ConsensusEngine.class, consensusEngineConfig);
        OutputWire consensusRoundsOutputWire = consensusEngineWiring.getOutputWire().buildTransformer("ConsensusRounds", "consensusEngineOutput", ConsensusEngineOutput::consensusRounds);
        return new ConsensusWiring((ComponentWiring<ConsensusEngine, ConsensusEngineOutput>)consensusEngineWiring, (OutputWire<List<ConsensusRound>>)consensusRoundsOutputWire);
    }

    public <T> InputWire<T> getInputWire(BiConsumer<ConsensusEngine, T> handler) {
        return this.componentWiring.getInputWire(handler);
    }

    public void bind(Supplier<ConsensusEngine> engineSupplier) {
        this.componentWiring.bind(engineSupplier);
    }

    public OutputWire<ConsensusEngineOutput> getOutputWire() {
        return this.componentWiring.getOutputWire();
    }

    public void flush() {
        this.componentWiring.flush();
    }

    public void startSquelching() {
        this.componentWiring.startSquelching();
    }

    public void stopSquelching() {
        this.componentWiring.stopSquelching();
    }
}

