/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base;

public record StackTrace(StackTraceElement[] frames) {
    public static StackTrace getStackTrace() {
        return new StackTrace(StackTrace.ignoreFrames(Thread.currentThread().getStackTrace(), 2));
    }

    public static StackTrace getStackTrace(Thread thread) {
        return new StackTrace(thread.getStackTrace());
    }

    public static StackTrace getStackTrace(Throwable t) {
        return new StackTrace(t.getStackTrace());
    }

    private static StackTraceElement[] ignoreFrames(StackTraceElement[] frames, int ignoredFrames) {
        if (frames.length <= ignoredFrames) {
            return new StackTraceElement[0];
        }
        StackTraceElement[] reducedFrames = new StackTraceElement[frames.length - ignoredFrames];
        System.arraycopy(frames, ignoredFrames, reducedFrames, 0, reducedFrames.length);
        return reducedFrames;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement element : this.frames) {
            if (element != this.frames[0]) {
                sb.append("\tat ");
            }
            sb.append(element.getClassName()).append(".").append(element.getMethodName()).append("(").append(element.getFileName()).append(":").append(element.getLineNumber()).append(")").append("\n");
        }
        return sb.toString();
    }
}

