/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.utility;

import com.swirlds.base.time.Time;
import com.swirlds.common.utility.RuntimeObjectRecord;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public final class RuntimeObjectRegistry {
    private static final Map<Class<?>, List<RuntimeObjectRecord>> RECORDS = new ConcurrentHashMap();
    private static final AtomicReference<Time> time = new AtomicReference<Object>(null);

    private RuntimeObjectRegistry() {
    }

    public static void initialize(@NonNull Time newValue) {
        if (!time.compareAndSet(null, Objects.requireNonNull(newValue))) {
            throw new IllegalStateException("RuntimeObjectRegistry has already been initialized");
        }
    }

    public static <T> RuntimeObjectRecord createRecord(Class<T> cls) {
        return RuntimeObjectRegistry.createRecord(cls, null);
    }

    public static <T> RuntimeObjectRecord createRecord(Class<T> cls, Object metadata) {
        time.compareAndSet(null, Time.getCurrent());
        Instant now = time.get().now();
        List classRecords = RECORDS.computeIfAbsent(cls, clsid -> Collections.synchronizedList(new ArrayList()));
        RuntimeObjectRecord objectRecord = new RuntimeObjectRecord(now, classRecords::remove, metadata);
        classRecords.add(objectRecord);
        return objectRecord;
    }

    public static <T> int getActiveObjectsCount(Class<T> cls) {
        List<RuntimeObjectRecord> classRecords = RECORDS.get(cls);
        return classRecords != null ? classRecords.size() : 0;
    }

    public static <T> Duration getOldestActiveObjectAge(Class<T> cls, Instant now) {
        List<RuntimeObjectRecord> classRecords = RECORDS.get(cls);
        if (classRecords == null) {
            return Duration.ZERO;
        }
        try {
            RuntimeObjectRecord oldestRecord = classRecords.get(0);
            return oldestRecord.getAge(now);
        }
        catch (IndexOutOfBoundsException e) {
            return Duration.ZERO;
        }
    }

    public static RuntimeObjectRecord getOldestActiveObjectRecord(Class<?> cls) {
        return RuntimeObjectRegistry.getActiveObjectRecord(cls, true);
    }

    public static RuntimeObjectRecord getNewestActiveObjectRecord(Class<?> cls) {
        return RuntimeObjectRegistry.getActiveObjectRecord(cls, false);
    }

    private static RuntimeObjectRecord getActiveObjectRecord(Class<?> cls, boolean oldest) {
        List<RuntimeObjectRecord> classRecords = RECORDS.get(cls);
        if (classRecords == null || classRecords.isEmpty()) {
            return null;
        }
        try {
            return oldest ? classRecords.getFirst() : classRecords.getLast();
        }
        catch (IndexOutOfBoundsException | NoSuchElementException e) {
            return null;
        }
    }

    public static Set<Class<?>> getTrackedClasses() {
        return Collections.unmodifiableSet(RECORDS.keySet());
    }

    public static void reset() {
        RECORDS.clear();
        time.set(null);
    }
}

