/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.base.test.fixtures.assertions;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.InstanceOfAssertFactory;

public class AssertionUtils {
    private static void assertHasAnyMessage(@NonNull AbstractThrowableAssert<?, ? extends Throwable> abstractThrowableAssert) {
        if (abstractThrowableAssert == null) {
            throw new NullPointerException("abstractThrowableAssert must not be null");
        }
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)abstractThrowableAssert.extracting(Throwable::getMessage, AssertionUtils.asString())).isNotEmpty()).isNotBlank()).isNotNull();
    }

    @NonNull
    private static InstanceOfAssertFactory<String, AbstractStringAssert<?>> asString() {
        return Assertions.as((InstanceOfAssertFactory)InstanceOfAssertFactories.STRING);
    }

    private static void assertHasAnyMessage(@NonNull Throwable t) {
        AssertionUtils.assertHasAnyMessage((AbstractThrowableAssert)Assertions.assertThat((Throwable)t).isNotNull());
    }

    public static <T extends Throwable> void assertThrowsWithMessage(@NonNull Class<T> throwableClass, @NonNull Runnable runnable) {
        Objects.requireNonNull(throwableClass, "throwableClass must not be null");
        Objects.requireNonNull(runnable, "runnable must not be null");
        try {
            runnable.run();
            Assertions.fail((String)"Expected an exception to be thrown");
        }
        catch (Throwable t) {
            Assertions.assertThat((Throwable)t).isInstanceOf(throwableClass);
            AssertionUtils.assertHasAnyMessage(t);
        }
    }

    public static void assertThrowsNPE(@NonNull Runnable runnable) {
        AssertionUtils.assertThrowsWithMessage(NullPointerException.class, runnable);
    }
}

