/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.block.stream.trace.codec;

import com.hedera.hapi.block.stream.trace.EvmTransactionLog;
import com.hedera.hapi.block.stream.trace.schema.EvmTransactionLogSchema;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class EvmTransactionLogJsonCodec
implements JsonCodec<EvmTransactionLog> {
    @NonNull
    public EvmTransactionLog parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            ContractID temp_contract_id = null;
            Bytes temp_data = Bytes.EMPTY;
            List<Bytes> temp_topics = Collections.emptyList();
            block12: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "contractId": {
                        temp_contract_id = (ContractID)ContractID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block12;
                    }
                    case "data": {
                        temp_data = Bytes.fromBase64((String)JsonTools.checkSize((String)"data", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block12;
                    }
                    case "topics": {
                        temp_topics = JsonTools.checkSize((String)"topics", (List)kvPair.value().arr().value(), (int)maxSize).stream().map(v -> Bytes.fromBase64((String)JsonTools.checkSize((String)"topics", (String)v.STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)))).toList();
                        continue block12;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new EvmTransactionLog(temp_contract_id, temp_data, temp_topics);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull EvmTransactionLog data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.contractId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"contractId", ContractID.JSON, (Object)data.contractId()));
        }
        if (data.data() != Bytes.EMPTY && data.data() != null && data.data().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"data", (Bytes)data.data()));
        }
        if (!data.topics().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)"topics", (FieldDefinition)EvmTransactionLogSchema.TOPICS, data.topics()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

