/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.HookId;
import com.hedera.hapi.node.contract.EvmTransactionResult;
import com.hedera.hapi.node.contract.InternalCallContext;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class EvmTransactionResultJsonCodec
implements JsonCodec<EvmTransactionResult> {
    @NonNull
    public EvmTransactionResult parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            AccountID temp_sender_id = null;
            ContractID temp_contract_id = null;
            Bytes temp_result_data = Bytes.EMPTY;
            String temp_error_message = "";
            long temp_gas_used = 0L;
            InternalCallContext temp_internal_call_context = null;
            HookId temp_executed_hook_id = null;
            block20: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "senderId": {
                        temp_sender_id = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block20;
                    }
                    case "contractId": {
                        temp_contract_id = (ContractID)ContractID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block20;
                    }
                    case "resultData": {
                        temp_result_data = Bytes.fromBase64((String)JsonTools.checkSize((String)"result_data", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block20;
                    }
                    case "errorMessage": {
                        temp_error_message = JsonTools.unescape((String)JsonTools.checkSize((String)"error_message", (String)kvPair.value().STRING().getText(), (int)maxSize));
                        continue block20;
                    }
                    case "gasUsed": {
                        temp_gas_used = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block20;
                    }
                    case "internalCallContext": {
                        temp_internal_call_context = (InternalCallContext)InternalCallContext.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block20;
                    }
                    case "executedHookId": {
                        temp_executed_hook_id = (HookId)HookId.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block20;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new EvmTransactionResult(temp_sender_id, temp_contract_id, temp_result_data, temp_error_message, temp_gas_used, temp_internal_call_context, temp_executed_hook_id);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull EvmTransactionResult data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.senderId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"senderId", AccountID.JSON, (Object)data.senderId()));
        }
        if (data.contractId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"contractId", ContractID.JSON, (Object)data.contractId()));
        }
        if (data.resultData() != Bytes.EMPTY && data.resultData() != null && data.resultData().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"resultData", (Bytes)data.resultData()));
        }
        if (data.errorMessage() != "") {
            fieldLines.add(JsonTools.field((String)"errorMessage", (String)data.errorMessage()));
        }
        if (data.gasUsed() != 0L) {
            fieldLines.add(JsonTools.field((String)"gasUsed", (long)data.gasUsed()));
        }
        if (data.internalCallContext() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"internalCallContext", InternalCallContext.JSON, (Object)data.internalCallContext()));
        }
        if (data.executedHookId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"executedHookId", HookId.JSON, (Object)data.executedHookId()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

