/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.hapi.node.transaction.FixedFee;
import com.hedera.hapi.node.transaction.FractionalFee;
import com.hedera.hapi.node.transaction.RoyaltyFee;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class CustomFeeJsonCodec
implements JsonCodec<CustomFee> {
    public static final OneOf<CustomFee.FeeOneOfType> FEE_UNSET = new OneOf((Enum)CustomFee.FeeOneOfType.UNSET, null);

    @NonNull
    public CustomFee parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            OneOf temp_fee = FEE_UNSET;
            AccountID temp_fee_collector_account_id = null;
            boolean temp_all_collectors_are_exempt = false;
            block16: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "fixedFee": {
                        temp_fee = new OneOf((Enum)CustomFee.FeeOneOfType.FIXED_FEE, FixedFee.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize));
                        continue block16;
                    }
                    case "fractionalFee": {
                        temp_fee = new OneOf((Enum)CustomFee.FeeOneOfType.FRACTIONAL_FEE, FractionalFee.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize));
                        continue block16;
                    }
                    case "royaltyFee": {
                        temp_fee = new OneOf((Enum)CustomFee.FeeOneOfType.ROYALTY_FEE, RoyaltyFee.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize));
                        continue block16;
                    }
                    case "feeCollectorAccountId": {
                        temp_fee_collector_account_id = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block16;
                    }
                    case "allCollectorsAreExempt": {
                        temp_all_collectors_are_exempt = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block16;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new CustomFee(temp_fee, temp_fee_collector_account_id, temp_all_collectors_are_exempt);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull CustomFee data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.fee().kind() == CustomFee.FeeOneOfType.FIXED_FEE) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"fixedFee", FixedFee.JSON, (Object)data.fixedFee()));
        }
        if (data.fee().kind() == CustomFee.FeeOneOfType.FRACTIONAL_FEE) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"fractionalFee", FractionalFee.JSON, (Object)data.fractionalFee()));
        }
        if (data.feeCollectorAccountId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"feeCollectorAccountId", AccountID.JSON, (Object)data.feeCollectorAccountId()));
        }
        if (data.fee().kind() == CustomFee.FeeOneOfType.ROYALTY_FEE) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"royaltyFee", RoyaltyFee.JSON, (Object)data.royaltyFee()));
        }
        if (data.allCollectorsAreExempt()) {
            fieldLines.add(JsonTools.field((String)"allCollectorsAreExempt", (boolean)data.allCollectorsAreExempt()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

