/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.base.test.fixtures.concurrent.internal;

import com.swirlds.base.test.fixtures.concurrent.TestExecutor;
import com.swirlds.base.test.fixtures.concurrent.internal.ConcurrentTestSupport;
import com.swirlds.base.test.fixtures.util.TestInjector;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.Method;
import java.util.Objects;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;

public class TestExecutorExtension
implements InvocationInterceptor,
ParameterResolver {
    public void interceptTestMethod(@NonNull InvocationInterceptor.Invocation<Void> invocation, @NonNull ReflectiveInvocationContext<Method> invocationContext, @NonNull ExtensionContext extensionContext) throws Throwable {
        Objects.requireNonNull(invocation, "invocation must not be null");
        Objects.requireNonNull(extensionContext, "extensionContext must not be null");
        try (ConcurrentTestSupport concurrentTestSupport = new ConcurrentTestSupport();){
            TestInjector.injectInTest(TestExecutor.class, () -> concurrentTestSupport, extensionContext);
            invocation.proceed();
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return TestInjector.supportsParameter(parameterContext, TestExecutor.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return TestInjector.resolveParameter(TestExecutor.class, parameterContext, ConcurrentTestSupport::new);
    }
}

