/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.base.test.fixtures.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import jakarta.inject.Inject;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;

public class TestInjector {
    private TestInjector() {
    }

    public static <T> void injectInTest(Class<T> type, Supplier<T> supplier, ExtensionContext extensionContext) {
        Class testClass = extensionContext.getRequiredTestClass();
        Arrays.stream(testClass.getDeclaredFields()).filter(field -> !Modifier.isFinal(field.getModifiers())).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> field.isAnnotationPresent(Inject.class)).filter(field -> Objects.equals(field.getType(), type)).forEach(field -> {
            try {
                field.setAccessible(true);
                field.set(extensionContext.getRequiredTestInstance(), supplier.get());
            }
            catch (Exception ex) {
                throw new RuntimeException("Error in injection", ex);
            }
        });
    }

    public static <T> boolean supportsParameter(@NonNull ParameterContext parameterContext, @NonNull Class<T> cls) {
        Objects.requireNonNull(parameterContext, "parameterContext must not be null");
        Objects.requireNonNull(cls, "cls must not be null");
        return Optional.of(parameterContext).map(ParameterContext::getParameter).map(Parameter::getType).filter(cls::isAssignableFrom).isPresent();
    }

    public static <T> T resolveParameter(@NonNull Class<T> type, @NonNull ParameterContext parameterContext, @NonNull Supplier<T> instanceSupplier) {
        Objects.requireNonNull(type, "type must not be null");
        Objects.requireNonNull(parameterContext, "parameterContext must not be null");
        Objects.requireNonNull(instanceSupplier, "instanceSupplier must not be null");
        return (T)Optional.of(parameterContext).map(ParameterContext::getParameter).map(Parameter::getType).filter(t -> t.equals(type)).map(t -> instanceSupplier.get()).orElseThrow(() -> new ParameterResolutionException("Could not resolve parameter"));
    }
}

