/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.datasource;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.virtualmap.datasource.VirtualHashRecord;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public interface VirtualDataSource {
    public static final int INVALID_PATH = -1;

    default public void close() throws IOException {
        this.close(false);
    }

    public void close(boolean var1) throws IOException;

    public void saveRecords(long var1, long var3, @NonNull Stream<VirtualHashRecord> var5, @NonNull Stream<VirtualLeafBytes> var6, @NonNull Stream<VirtualLeafBytes> var7, boolean var8) throws IOException;

    @Nullable
    public VirtualLeafBytes loadLeafRecord(Bytes var1) throws IOException;

    @Nullable
    public VirtualLeafBytes loadLeafRecord(long var1) throws IOException;

    public long findKey(Bytes var1) throws IOException;

    @Nullable
    public Hash loadHash(long var1) throws IOException;

    default public boolean loadAndWriteHash(long path, SerializableDataOutputStream out) throws IOException {
        Hash hash = this.loadHash(path);
        if (hash == null) {
            return false;
        }
        hash.serialize(out);
        return true;
    }

    public void snapshot(Path var1) throws IOException;

    public void copyStatisticsFrom(VirtualDataSource var1);

    public void registerMetrics(Metrics var1);

    public void enableBackgroundCompaction();

    public void stopAndDisableBackgroundCompaction();

    public long getFirstLeafPath();

    public long getLastLeafPath();
}

