/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.crypto;

import com.swirlds.common.test.fixtures.io.ResourceNotFoundException;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.SerializableX509Certificate;

public class PreGeneratedX509Certs {
    public static final String SIG_CERT_FILE = "sigCerts.data";
    public static final String AGREE_CERT_FILE = "agrCerts.data";
    private static final Map<NodeId, SerializableX509Certificate> sigCerts = new HashMap<NodeId, SerializableX509Certificate>();
    private static final Map<NodeId, SerializableX509Certificate> agreeCerts = new HashMap<NodeId, SerializableX509Certificate>();

    private PreGeneratedX509Certs() {
        throw new IllegalStateException("Utility class");
    }

    @Nullable
    public static SerializableX509Certificate getSigCert(long nodeId) {
        if (sigCerts.isEmpty()) {
            PreGeneratedX509Certs.loadCerts();
            if (sigCerts.isEmpty()) {
                return null;
            }
        }
        long index = nodeId % (long)sigCerts.size();
        return sigCerts.get(NodeId.of((long)index));
    }

    public static SerializableX509Certificate getAgreeCert(long nodeId) {
        if (agreeCerts.isEmpty()) {
            PreGeneratedX509Certs.loadCerts();
            if (agreeCerts.isEmpty()) {
                return null;
            }
        }
        long index = nodeId % (long)agreeCerts.size();
        return agreeCerts.get(NodeId.of((long)index));
    }

    private static void loadCerts() {
        InputStream agreeCertIs;
        InputStream sigCertIs;
        try {
            sigCertIs = PreGeneratedX509Certs.class.getResourceAsStream(SIG_CERT_FILE);
            agreeCertIs = PreGeneratedX509Certs.class.getResourceAsStream(AGREE_CERT_FILE);
            if (sigCertIs == null || agreeCertIs == null) {
                return;
            }
        }
        catch (ResourceNotFoundException e) {
            return;
        }
        SerializableDataInputStream sigCertDis = new SerializableDataInputStream(sigCertIs);
        SerializableDataInputStream agreeCertDis = new SerializableDataInputStream(agreeCertIs);
        try {
            int numSigCerts = sigCertDis.readInt();
            for (int i = 0; i < numSigCerts; ++i) {
                SerializableX509Certificate sigCert = (SerializableX509Certificate)sigCertDis.readSerializable(false, SerializableX509Certificate::new);
                sigCerts.put(NodeId.of((long)i), sigCert);
            }
            int numAgreeCerts = agreeCertDis.readInt();
            for (int i = 0; i < numAgreeCerts; ++i) {
                SerializableX509Certificate agreeCert = (SerializableX509Certificate)agreeCertDis.readSerializable(false, SerializableX509Certificate::new);
                agreeCerts.put(NodeId.of((long)i), agreeCert);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("critical failure in loading certificates", e);
        }
    }

    public static X509Certificate createBadCertificate() {
        return new X509Certificate(){

            @Override
            public void checkValidity() {
            }

            @Override
            public void checkValidity(Date date) {
            }

            @Override
            public int getVersion() {
                return 0;
            }

            @Override
            public BigInteger getSerialNumber() {
                return null;
            }

            @Override
            public Principal getIssuerDN() {
                return null;
            }

            @Override
            public Principal getSubjectDN() {
                return null;
            }

            @Override
            public Date getNotBefore() {
                return null;
            }

            @Override
            public Date getNotAfter() {
                return null;
            }

            @Override
            public byte[] getTBSCertificate() {
                return new byte[0];
            }

            @Override
            public byte[] getSignature() {
                return new byte[0];
            }

            @Override
            public String getSigAlgName() {
                return "";
            }

            @Override
            public String getSigAlgOID() {
                return "";
            }

            @Override
            public byte[] getSigAlgParams() {
                return new byte[0];
            }

            @Override
            public boolean[] getIssuerUniqueID() {
                return new boolean[0];
            }

            @Override
            public boolean[] getSubjectUniqueID() {
                return new boolean[0];
            }

            @Override
            public boolean[] getKeyUsage() {
                return new boolean[0];
            }

            @Override
            public int getBasicConstraints() {
                return 0;
            }

            @Override
            public byte[] getEncoded() {
                return new byte[0];
            }

            @Override
            public void verify(PublicKey key) {
            }

            @Override
            public void verify(PublicKey key, String sigProvider) {
            }

            @Override
            public String toString() {
                return "";
            }

            @Override
            public PublicKey getPublicKey() {
                return null;
            }

            @Override
            public boolean hasUnsupportedCriticalExtension() {
                return false;
            }

            @Override
            public Set<String> getCriticalExtensionOIDs() {
                return Set.of();
            }

            @Override
            public Set<String> getNonCriticalExtensionOIDs() {
                return Set.of();
            }

            @Override
            public byte[] getExtensionValue(String oid) {
                return new byte[0];
            }
        };
    }
}

