/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.event.source;

import com.swirlds.common.test.fixtures.TransactionGenerator;
import com.swirlds.platform.internal.EventImpl;
import com.swirlds.platform.test.fixtures.event.source.AbstractEventSource;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class BranchingEventSource
extends AbstractEventSource {
    private int maximumBranchCount;
    private double branchProbability;
    private List<LinkedList<EventImpl>> branches;
    private int currentBranch;

    public BranchingEventSource() {
        this(true, DEFAULT_TRANSACTION_GENERATOR);
    }

    public BranchingEventSource(boolean useFakeHashes) {
        this(useFakeHashes, DEFAULT_TRANSACTION_GENERATOR);
    }

    public BranchingEventSource(boolean useFakeHashes, TransactionGenerator transactionGenerator) {
        super(useFakeHashes, transactionGenerator);
        this.maximumBranchCount = 3;
        this.branchProbability = 0.01;
        this.setMaximumBranchCount(this.maximumBranchCount);
    }

    private BranchingEventSource(BranchingEventSource that) {
        super(that);
        this.setMaximumBranchCount(that.maximumBranchCount);
        this.branchProbability = that.branchProbability;
    }

    public int getMaximumBranchCount() {
        return this.maximumBranchCount;
    }

    public BranchingEventSource setMaximumBranchCount(int maximumBranchCount) {
        if (maximumBranchCount < 1) {
            throw new IllegalArgumentException("Requires at least one branch");
        }
        this.maximumBranchCount = maximumBranchCount;
        this.branches = new ArrayList<LinkedList<EventImpl>>(maximumBranchCount);
        return this;
    }

    public double getBranchProbability() {
        return this.branchProbability;
    }

    public BranchingEventSource setBranchProbability(double branchProbability) {
        this.branchProbability = branchProbability;
        return this;
    }

    @Override
    public BranchingEventSource copy() {
        return new BranchingEventSource(this);
    }

    @Override
    public void reset() {
        super.reset();
        this.branches = new ArrayList<LinkedList<EventImpl>>(this.maximumBranchCount);
    }

    @Override
    public EventImpl getRecentEvent(Random random, int index) {
        if (this.branches.isEmpty()) {
            return null;
        }
        this.currentBranch = random.nextInt(this.branches.size());
        LinkedList<EventImpl> events = this.branches.get(this.currentBranch);
        if (events.size() == 0) {
            return null;
        }
        if (index >= events.size()) {
            return events.getLast();
        }
        return events.get(index);
    }

    private boolean shouldBranch(Random random) {
        return this.maximumBranchCount > 1 && random.nextDouble() < this.branchProbability;
    }

    private void branch(Random random) {
        if (this.branches.size() < this.maximumBranchCount) {
            this.currentBranch = this.branches.size();
            this.branches.add(new LinkedList());
        } else {
            int newEventIndex;
            while ((newEventIndex = random.nextInt(this.branches.size())) == this.currentBranch) {
            }
            this.currentBranch = newEventIndex;
        }
    }

    @Override
    public void setLatestEvent(Random random, EventImpl event) {
        if (this.shouldBranch(random)) {
            this.branch(random);
        }
        if (this.branches.size() == 0) {
            this.branches.add(new LinkedList());
            this.currentBranch = 0;
        }
        LinkedList<EventImpl> branch = this.branches.get(this.currentBranch);
        branch.addFirst(event);
        this.pruneEventList(branch);
    }

    public List<LinkedList<EventImpl>> getBranches() {
        return this.branches;
    }
}

