/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.impl.internal;

import com.swirlds.base.ArgumentUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.impl.internal.ConfigDataService;
import com.swirlds.config.impl.internal.ConfigLifecycle;
import com.swirlds.config.impl.internal.ConfigListUtils;
import com.swirlds.config.impl.internal.ConfigPropertiesService;
import com.swirlds.config.impl.internal.ConfigValidationService;
import com.swirlds.config.impl.internal.ConverterService;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;

class ConfigurationImpl
implements Configuration,
ConfigLifecycle {
    private final ConfigPropertiesService propertiesService;
    private final ConverterService converterService;
    private final ConfigDataService configDataService;
    private final ConfigValidationService validationService;
    private boolean initialized = false;

    ConfigurationImpl(@NonNull ConfigPropertiesService propertiesService, @NonNull ConverterService converterService, @NonNull ConfigValidationService validationService) {
        this.propertiesService = Objects.requireNonNull(propertiesService, "propertiesService must not be null");
        this.converterService = Objects.requireNonNull(converterService, "converterService must not be null");
        this.validationService = Objects.requireNonNull(validationService, "validationService must not be null");
        this.configDataService = new ConfigDataService(this, converterService);
    }

    @NonNull
    public Stream<String> getPropertyNames() {
        return this.propertiesService.getPropertyNames();
    }

    public boolean exists(@NonNull String propertyName) {
        ArgumentUtils.throwArgBlank((String)propertyName, (String)"propertyName");
        return this.propertiesService.containsKey(propertyName);
    }

    public boolean isListValue(@NonNull String propertyName) {
        return this.propertiesService.isListProperty(propertyName);
    }

    @Nullable
    public <T> T getValue(@NonNull String propertyName, @NonNull Class<T> propertyType) {
        ArgumentUtils.throwArgBlank((String)propertyName, (String)"propertyName");
        Objects.requireNonNull(propertyType, "propertyType must not be null");
        String rawValue = this.getValue(propertyName);
        if (Objects.equals(propertyType, String.class)) {
            return (T)rawValue;
        }
        return this.converterService.convert(rawValue, propertyType);
    }

    @Nullable
    public <T> T getValue(@NonNull String propertyName, @NonNull Class<T> propertyType, @Nullable T defaultValue) {
        ArgumentUtils.throwArgBlank((String)propertyName, (String)"propertyName");
        Objects.requireNonNull(propertyType, "propertyType must not be null");
        if (!this.exists(propertyName)) {
            return defaultValue;
        }
        return this.getValue(propertyName, propertyType);
    }

    @Nullable
    public String getValue(@NonNull String propertyName) {
        ArgumentUtils.throwArgBlank((String)propertyName, (String)"propertyName");
        if (this.propertiesService.isListProperty(propertyName)) {
            throw new NoSuchElementException("Property '" + propertyName + "' is a list property");
        }
        if (!this.exists(propertyName)) {
            throw new NoSuchElementException("Property '" + propertyName + "' not defined in configuration");
        }
        return this.propertiesService.getProperty(propertyName);
    }

    @Nullable
    public String getValue(@NonNull String propertyName, @Nullable String defaultValue) {
        ArgumentUtils.throwArgBlank((String)propertyName, (String)"propertyName");
        if (this.propertiesService.isListProperty(propertyName)) {
            throw new NoSuchElementException("Property '" + propertyName + "' is a list property");
        }
        if (!this.exists(propertyName)) {
            return defaultValue;
        }
        return this.propertiesService.getProperty(propertyName);
    }

    @Nullable
    public List<String> getValues(@NonNull String propertyName) {
        ArgumentUtils.throwArgBlank((String)propertyName, (String)"propertyName");
        if (!this.propertiesService.isListProperty(propertyName)) {
            throw new NoSuchElementException("Property '" + propertyName + "' is not a list property");
        }
        if (!this.exists(propertyName)) {
            throw new NoSuchElementException("Property '" + propertyName + "' not defined in configuration");
        }
        return this.propertiesService.getListProperty(propertyName);
    }

    @Nullable
    public List<String> getValues(@NonNull String propertyName, @Nullable List<String> defaultValue) {
        ArgumentUtils.throwArgBlank((String)propertyName, (String)"propertyName");
        if (!this.propertiesService.isListProperty(propertyName)) {
            throw new NoSuchElementException("Property '" + propertyName + "' is not a list property");
        }
        if (!this.exists(propertyName)) {
            return defaultValue;
        }
        return this.propertiesService.getListProperty(propertyName);
    }

    @Nullable
    public <T> List<T> getValues(@NonNull String propertyName, @NonNull Class<T> propertyType) {
        List<String> values;
        ArgumentUtils.throwArgBlank((String)propertyName, (String)"propertyName");
        Objects.requireNonNull(propertyType, "propertyType must not be null");
        if (!this.propertiesService.isListProperty(propertyName)) {
            String value = this.getValue(propertyName);
            values = ConfigListUtils.createList(value);
        } else {
            values = this.getValues(propertyName);
        }
        if (values == null) {
            return null;
        }
        return values.stream().map(v -> this.converterService.convert((String)v, propertyType)).toList();
    }

    @Nullable
    public <T> List<T> getValues(@NonNull String propertyName, @NonNull Class<T> propertyType, @Nullable List<T> defaultValue) {
        ArgumentUtils.throwArgBlank((String)propertyName, (String)"propertyName");
        Objects.requireNonNull(propertyType, "propertyType must not be null");
        if (!this.exists(propertyName)) {
            return defaultValue;
        }
        return this.getValues(propertyName, propertyType);
    }

    private <T> Set<T> createStableSet(@Nullable Collection<T> collection, @NonNull Class<T> propertyType) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return Collections.emptySet();
        }
        if (Enum.class.isAssignableFrom(propertyType)) {
            return Collections.unmodifiableSet(EnumSet.copyOf(collection));
        }
        if (Comparable.class.isAssignableFrom(propertyType)) {
            return Collections.unmodifiableSortedSet(new TreeSet<T>(collection));
        }
        return Collections.unmodifiableSet(new LinkedHashSet<T>(collection));
    }

    @Nullable
    public Set<String> getValueSet(@NonNull String propertyName) {
        List<String> values = this.getValues(propertyName);
        return this.createStableSet(values, String.class);
    }

    @Nullable
    public Set<String> getValueSet(@NonNull String propertyName, @Nullable Set<String> defaultValue) {
        if (!this.exists(propertyName)) {
            return this.createStableSet(defaultValue, String.class);
        }
        return this.createStableSet(this.getValues(propertyName), String.class);
    }

    @Nullable
    public <T> Set<T> getValueSet(@NonNull String propertyName, @NonNull Class<T> propertyType) throws NoSuchElementException, IllegalArgumentException {
        List<T> values = this.getValues(propertyName, propertyType);
        return this.createStableSet(values, propertyType);
    }

    @Nullable
    public <T> Set<T> getValueSet(@NonNull String propertyName, @NonNull Class<T> propertyType, @Nullable Set<T> defaultValue) throws IllegalArgumentException {
        if (!this.exists(propertyName)) {
            return this.createStableSet(defaultValue, propertyType);
        }
        return this.createStableSet(this.getValues(propertyName, propertyType), propertyType);
    }

    @NonNull
    public <T extends Record> T getConfigData(@NonNull Class<T> type) {
        return this.configDataService.getConfigData(type);
    }

    @Override
    public void init() {
        this.throwIfInitialized();
        this.configDataService.init();
        this.validationService.validate(this);
        this.initialized = true;
    }

    @Override
    public void dispose() {
        this.initialized = false;
        this.configDataService.dispose();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public <T extends Record> void addConfigDataType(@NonNull Class<T> type) {
        this.configDataService.addConfigDataType(type);
    }

    @NonNull
    public Collection<Class<? extends Record>> getConfigDataTypes() {
        return this.configDataService.getConfigDataTypes();
    }
}

