/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.impl.validators;

import com.swirlds.config.api.converter.ConfigConverter;
import com.swirlds.config.api.validation.ConfigPropertyConstraint;
import com.swirlds.config.api.validation.ConfigViolation;
import com.swirlds.config.api.validation.PropertyMetadata;
import com.swirlds.config.impl.validators.DefaultConfigViolation;
import java.util.Objects;

public class PropertyValueConvertableConstraint<T>
implements ConfigPropertyConstraint<T> {
    public ConfigViolation check(PropertyMetadata<T> metadata) {
        Objects.requireNonNull(metadata, "metadata must not be null");
        if (!metadata.exists()) {
            String message = "Property '" + metadata.getName() + "' must be defined";
            return DefaultConfigViolation.of(metadata, message);
        }
        ConfigConverter converter = metadata.getConverter();
        if (converter == null) {
            String message = "No converter for type '" + String.valueOf(metadata.getValueType()) + "' + of property '" + metadata.getName() + "' defined";
            return DefaultConfigViolation.of(metadata, message);
        }
        try {
            converter.convert(metadata.getRawValue());
        }
        catch (Exception e) {
            String message = "Value '" + metadata.getRawValue() + "' of property '" + metadata.getName() + "' can not be converted to '" + String.valueOf(metadata.getValueType()) + "'";
            return DefaultConfigViolation.of(metadata, message);
        }
        return null;
    }
}

