/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime;

import com.hedera.pbj.runtime.MalformedProtobufException;
import com.hedera.pbj.runtime.MalformedUtf8Exception;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class Utf8Tools {
    static int encodedLength(CharSequence sequence) throws IOException {
        int i;
        int utf16Length;
        if (sequence == null) {
            return 0;
        }
        int utf8Length = utf16Length = sequence.length();
        for (i = 0; i < utf16Length && sequence.charAt(i) < '\u0080'; ++i) {
        }
        while (i < utf16Length) {
            char c = sequence.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
            } else {
                utf8Length += Utf8Tools.encodedLengthGeneral(sequence, i);
                break;
            }
            ++i;
        }
        if (utf8Length < utf16Length) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)utf8Length + 0x100000000L));
        }
        return utf8Length;
    }

    private static int encodedLengthGeneral(CharSequence sequence, int start) throws IOException {
        int utf16Length = sequence.length();
        int utf8Length = 0;
        for (int i = start; i < utf16Length; ++i) {
            char c = sequence.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
                continue;
            }
            utf8Length += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int cp = Character.codePointAt(sequence, i);
            if (cp < 65536) {
                throw new MalformedProtobufException("Unpaired surrogate at index " + i + " of " + utf16Length);
            }
            ++i;
        }
        return utf8Length;
    }

    static void encodeUtf8(CharSequence in, WritableSequentialData out) throws IOException {
        int inLength = in.length();
        for (int inIx = 0; inIx < inLength; ++inIx) {
            char low;
            char c = in.charAt(inIx);
            if (c < '\u0080') {
                out.writeByte((byte)c);
                continue;
            }
            if (c < '\u0800') {
                out.writeByte2((byte)(0xC0 | c >>> 6), (byte)(0x80 | 0x3F & c));
                continue;
            }
            if (c < '\ud800' || '\udfff' < c) {
                out.writeByte3((byte)(0xE0 | c >>> 12), (byte)(0x80 | 0x3F & c >>> 6), (byte)(0x80 | 0x3F & c));
                continue;
            }
            if (inIx + 1 == inLength || !Character.isSurrogatePair(c, low = in.charAt(++inIx))) {
                throw new MalformedProtobufException("Unpaired surrogate at index " + inIx + " of " + inLength);
            }
            int codePoint = Character.toCodePoint(c, low);
            out.writeByte4((byte)(0xF0 | codePoint >>> 18), (byte)(0x80 | 0x3F & codePoint >>> 12), (byte)(0x80 | 0x3F & codePoint >>> 6), (byte)(0x80 | 0x3F & codePoint));
        }
    }

    public static int encodeUtf8(@NonNull byte[] out, int offset, String in) {
        char c;
        int i;
        int utf16Length = in.length();
        int j = offset;
        for (i = 0; i < utf16Length && (c = in.charAt(i)) < '\u0080'; ++i) {
            out[j + i] = (byte)c;
        }
        if (i == utf16Length) {
            return j + utf16Length - offset;
        }
        j += i;
        while (i < utf16Length) {
            c = in.charAt(i);
            if (c < '\u0080') {
                out[j++] = (byte)c;
            } else if (c < '\u0800') {
                out[j++] = (byte)(0x3C0 | c >>> 6);
                out[j++] = (byte)(0x80 | 0x3F & c);
            } else if (c < '\ud800' || '\udfff' < c) {
                out[j++] = (byte)(0x1E0 | c >>> 12);
                out[j++] = (byte)(0x80 | 0x3F & c >>> 6);
                out[j++] = (byte)(0x80 | 0x3F & c);
            } else {
                char low;
                if (i + 1 == in.length() || !Character.isSurrogatePair(c, low = in.charAt(++i))) {
                    throw new MalformedUtf8Exception("Unpaired surrogate at index " + (i - 1) + " of " + utf16Length);
                }
                int codePoint = Character.toCodePoint(c, low);
                out[j++] = (byte)(0xF0 | codePoint >>> 18);
                out[j++] = (byte)(0x80 | 0x3F & codePoint >>> 12);
                out[j++] = (byte)(0x80 | 0x3F & codePoint >>> 6);
                out[j++] = (byte)(0x80 | 0x3F & codePoint);
            }
            ++i;
        }
        return j - offset;
    }
}

