/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.utility.Pair;
import com.swirlds.common.utility.throttle.MultiThrottle;
import com.swirlds.common.utility.throttle.Throttle;
import com.swirlds.demo.platform.ControlAction;
import com.swirlds.demo.platform.PAYLOAD_CATEGORY;
import com.swirlds.demo.platform.PAYLOAD_TYPE;
import com.swirlds.demo.platform.SubmitConfig;
import com.swirlds.demo.platform.actions.QuorumTriggeredAction;
import com.swirlds.demo.platform.fs.stresstest.proto.ControlType;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.system.Platform;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.util.Supplier;
import org.hiero.consensus.transaction.TransactionPoolNexus;

public class TransactionSubmitter {
    private static final Logger logger = LogManager.getLogger(TransactionSubmitter.class);
    private static final Marker LOGM_DEMO_INFO = MarkerManager.getMarker((String)"DEMO_INFO");
    private static final Marker LOGM_SUBMIT_DETAIL = MarkerManager.getMarker((String)"SUBMIT_DETAIL");
    private static final Marker LOGM_EXCEPTION = MarkerManager.getMarker((String)"EXCEPTION");
    private static final int FREEZE_SUBMIT_ATTEMPT_SLEEP = 250;
    private static final int FREEZE_SUBMIT_MAX_ATTEMPTS = 10;
    public static final long USE_DEFAULT_TPS = 0L;
    private volatile long customizedTPS = 0L;
    private static final double ALLOWED_CATCHUP_DELTA = 1.3;
    private static AtomicBoolean forcePauseCanSubmitMore;
    private final AtomicBoolean paused = new AtomicBoolean(false);
    SUBMIT_GOAL goal = SUBMIT_GOAL.BYTES_PER_SECOND_PER_NODE;
    long bytesPerSecondGoal = 1000000L;
    float tranPerSecondGoal = 1000.0f;
    long eventsPerSecondGoal = 500L;
    float roundsPerSecondGoal = 30.0f;
    float tranPerEventGoal = 200.0f;
    float c2cLatencySecond = 3.0f;
    long accumulatedBytes = 0L;
    long accumulatedTrans = 0L;
    long accumulatedEvent = 0L;
    long accumulatedRound = 0L;
    long cycleStartMS = 0L;
    long pauseAfter = 0L;
    int pauseSeconds = 15;
    boolean waitPauseFinished = false;
    long pauseStartTime;
    int C2CDelayThreshold = 5;
    private SubmitConfig submitConfig;
    private Map<PAYLOAD_TYPE, Throttle> throttleForTxTypes;
    private Map<PAYLOAD_CATEGORY, Throttle> throttleForTxCategory;
    private QuorumTriggeredAction<ControlAction> controlQuorum;

    public static AtomicBoolean getForcePauseCanSubmitMore() {
        return forcePauseCanSubmitMore;
    }

    public static void setForcePauseCanSubmitMore(AtomicBoolean forcePauseCanSubmitMore) {
        TransactionSubmitter.forcePauseCanSubmitMore = forcePauseCanSubmitMore;
    }

    TransactionSubmitter(SubmitConfig sc, QuorumTriggeredAction<ControlAction> controlQuorum) {
        this.submitConfig = sc;
        this.controlQuorum = controlQuorum;
        SUBMIT_GOAL goal = this.submitConfig.getSystemMetric();
        float value = this.submitConfig.getMetricThreshold();
        long pauseAfter = this.submitConfig.getPauseAfter();
        int pauseSeconds = this.submitConfig.getPauseSeconds();
        int C2CDelayThreshold = this.submitConfig.getC2CDelayThreshold();
        this.goal = goal;
        if (this.goal == SUBMIT_GOAL.BYTES_PER_SECOND_PER_NODE) {
            this.bytesPerSecondGoal = (long)value;
        } else if (this.goal == SUBMIT_GOAL.TRANS_PER_SECOND_PER_NODE) {
            this.tranPerSecondGoal = value;
        } else if (this.goal == SUBMIT_GOAL.EVENTS_PER_SECOND_WHOLE_NETWORK) {
            this.eventsPerSecondGoal = (long)value;
        } else if (this.goal == SUBMIT_GOAL.ROUNDS_PER_SECOND_WHOLE_NETWORK) {
            this.roundsPerSecondGoal = value;
        } else if (this.goal == SUBMIT_GOAL.TRANS_PER_EVENT_WHOLE_NETWORK) {
            this.tranPerEventGoal = value;
        } else if (this.goal == SUBMIT_GOAL.C2C_LATENCY) {
            this.c2cLatencySecond = value;
        }
        logger.info(LOGM_DEMO_INFO, "Goal is " + String.valueOf((Object)goal) + " targe " + value);
        this.pauseAfter = pauseAfter;
        this.pauseSeconds = pauseSeconds;
        this.C2CDelayThreshold = C2CDelayThreshold;
        if (this.submitConfig.isEnableThrottling()) {
            this.submitConfig.initThrottling();
            this.throttleForTxTypes = this.submitConfig.getThrottleForTxTypes();
            this.throttleForTxCategory = this.submitConfig.getThrottleForTxCategory();
        }
    }

    public void udpateStatistics(int length) {
        if (this.accumulatedTrans == 0L) {
            this.cycleStartMS = System.currentTimeMillis();
        }
        ++this.accumulatedTrans;
        this.accumulatedBytes += (long)length;
    }

    public void sendTransaction(TransactionPoolNexus transactionPool, byte[] data) {
        while (!transactionPool.submitApplicationTransaction(Bytes.wrap((byte[])data))) {
        }
    }

    public boolean trySubmit(Platform platform, TransactionPoolNexus transactionPool, Pair<byte[], PAYLOAD_TYPE> data) {
        if (this.controlQuorum.hasQuorum(ControlAction.of(ControlType.EXIT_VALIDATION))) {
            logger.info(LOGM_DEMO_INFO, "Submitter has exited pause due to reaching quorum on {} messages", (Object)ControlType.EXIT_VALIDATION);
            this.paused.set(false);
            this.cycleStartMS = System.currentTimeMillis();
            this.accumulatedTrans = 0L;
            return false;
        }
        if (this.controlQuorum.hasQuorum(ControlAction.of(ControlType.ENTER_VALIDATION))) {
            logger.info(LOGM_DEMO_INFO, "Submitter has entered pause due to reaching quorum on {} messages", (Object)ControlType.ENTER_VALIDATION);
            this.paused.set(true);
            return false;
        }
        if (this.controlQuorum.hasQuorum(ControlAction.of(ControlType.EXIT_SYNC))) {
            logger.info(LOGM_DEMO_INFO, "Submitter has exited pause due to reaching quorum on {} messages", (Object)ControlType.EXIT_SYNC);
            this.paused.set(false);
            this.cycleStartMS = System.currentTimeMillis();
            this.accumulatedTrans = 0L;
            return false;
        }
        if (this.controlQuorum.hasQuorum(ControlAction.of(ControlType.ENTER_SYNC))) {
            logger.info(LOGM_DEMO_INFO, "Submitter has entered pause due to reaching quorum on {} messages", (Object)ControlType.ENTER_SYNC);
            this.paused.set(true);
            return false;
        }
        if (this.paused.get()) {
            return false;
        }
        if (this.canSubmitMore(platform)) {
            PAYLOAD_TYPE type;
            if (this.submitConfig.isEnableThrottling() && (type = (PAYLOAD_TYPE)((Object)data.value())) != null && !this.handleThrottles(type)) {
                return false;
            }
            if (!transactionPool.submitApplicationTransaction(Bytes.wrap((byte[])((byte[])data.key())))) {
                logger.info(LOGM_SUBMIT_DETAIL, "Submitter will not submit this transaction because platform failed to createTransaction");
                return false;
            }
            if (this.accumulatedTrans == 0L) {
                this.cycleStartMS = System.currentTimeMillis();
            }
            ++this.accumulatedTrans;
            this.accumulatedBytes += (long)((byte[])data.key()).length;
            if (this.pauseAfter > 0L && this.accumulatedTrans == this.pauseAfter && !this.waitPauseFinished) {
                this.waitPauseFinished = true;
                this.pauseStartTime = System.currentTimeMillis() / 1000L;
                logger.info(LOGM_DEMO_INFO, "Pause started");
            }
            return true;
        }
        logger.info(LOGM_SUBMIT_DETAIL, "Submitter will not submit this transaction because canSubmitMore returns false");
        return false;
    }

    private boolean handleThrottles(PAYLOAD_TYPE type) {
        Throttle typeThrottle;
        Throttle categoryThrottle;
        MultiThrottle multiThrottle = new MultiThrottle();
        PAYLOAD_CATEGORY category = type.getPayloadCategory();
        if (this.throttleForTxCategory != null && (categoryThrottle = this.throttleForTxCategory.get((Object)category)) != null) {
            multiThrottle.addThrottle(categoryThrottle);
        }
        if (this.throttleForTxTypes != null && (typeThrottle = this.throttleForTxTypes.get((Object)type)) != null) {
            multiThrottle.addThrottle(typeThrottle);
        }
        if (multiThrottle.allow()) {
            return true;
        }
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = type::name;
        supplierArray[1] = category::name;
        logger.info(LOGM_SUBMIT_DETAIL, "Submitter will not submit this transaction because type transaction throttle doesn't allow for type {} or category {}", supplierArray);
        return false;
    }

    public boolean canSubmitMore(Platform platform) {
        boolean result = false;
        long now = System.currentTimeMillis();
        Metrics metrics = platform.getContext().getMetrics();
        if (TransactionSubmitter.getForcePauseCanSubmitMore().get()) {
            return false;
        }
        if (this.waitPauseFinished) {
            if (System.currentTimeMillis() / 1000L > this.pauseStartTime + (long)this.pauseSeconds) {
                this.waitPauseFinished = false;
                logger.info(LOGM_DEMO_INFO, "Pause finished");
            } else {
                logger.info(LOGM_SUBMIT_DETAIL, "Submitter cannot submit the transaction because pause is not finished");
                return false;
            }
        }
        if (this.goal == SUBMIT_GOAL.BYTES_PER_SECOND_PER_NODE) {
            float realBytesPerSecond = (float)this.accumulatedBytes * 1000.0f / (float)(now - this.cycleStartMS + 1L);
            return !(realBytesPerSecond > (float)this.bytesPerSecondGoal);
        }
        if (this.goal == SUBMIT_GOAL.TRANS_PER_SECOND_PER_NODE && this.customizedTPS != 0L) {
            float realTranPerSecond = (float)this.accumulatedTrans * 1000.0f / (float)(now - this.cycleStartMS + 1L);
            if (realTranPerSecond > (float)this.customizedTPS) {
                logger.info(LOGM_SUBMIT_DETAIL, "Submitter cannot submit the transaction because realTranPerSecond {} is greater than customizedTPS {}", (Object)Float.valueOf(realTranPerSecond), (Object)this.customizedTPS);
                return false;
            }
            return true;
        }
        if (this.goal == SUBMIT_GOAL.TRANS_PER_SECOND_PER_NODE) {
            double tranSubTPS = (Double)metrics.getValue("Debug:info", "tranSubTPS");
            if (tranSubTPS > (double)this.tranPerSecondGoal * 1.3) {
                return false;
            }
            float realTranPerSecond = (float)this.accumulatedTrans * 1000.0f / (float)(now - this.cycleStartMS + 1L);
            if (realTranPerSecond > this.tranPerSecondGoal) {
                logger.info(LOGM_SUBMIT_DETAIL, "Submitter cannot submit the transaction because realTranPerSecond {} is greater than tranPerSecondGoal {}", (Object)Float.valueOf(realTranPerSecond), (Object)Float.valueOf(this.tranPerSecondGoal));
                return false;
            }
            return true;
        }
        if (this.goal == SUBMIT_GOAL.EVENTS_PER_SECOND_WHOLE_NETWORK) {
            double realEvensPerSecond = (Double)metrics.getValue("platform", "events_per_sec");
            return realEvensPerSecond > (double)this.eventsPerSecondGoal;
        }
        if (this.goal == SUBMIT_GOAL.ROUNDS_PER_SECOND_WHOLE_NETWORK) {
            double realRoundsPerSecond = (Double)metrics.getValue("platform", "rounds_per_sec");
            return realRoundsPerSecond <= (double)this.roundsPerSecondGoal;
        }
        if (this.goal == SUBMIT_GOAL.TRANS_PER_EVENT_WHOLE_NETWORK) {
            double realTranPerEvent = (Double)metrics.getValue("platform", "trans_per_event");
            return realTranPerEvent <= (double)this.tranPerEventGoal;
        }
        if (this.goal == SUBMIT_GOAL.C2C_LATENCY) {
            double realLatency = (Double)metrics.getValue("platform", "secC2C");
            return realLatency <= (double)this.c2cLatencySecond;
        }
        return result;
    }

    public boolean sendFreezeTran(TransactionPoolNexus transactionPool, byte[] data) {
        logger.info(LOGM_DEMO_INFO, "Sending Freeze Transaction...");
        int attemptCount = 0;
        while (!transactionPool.submitApplicationTransaction(Bytes.wrap((byte[])data))) {
            try {
                if (++attemptCount > 10) {
                    return false;
                }
                Thread.sleep(250L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        logger.info(LOGM_DEMO_INFO, "Finished Sending Freeze Transaction.");
        return true;
    }

    public long getCustomizedTPS() {
        return this.customizedTPS;
    }

    public void setCustomizedTPS(long customizedTPS) {
        boolean isTPSChanged = false;
        if (this.customizedTPS == 0L && this.customizedTPS != customizedTPS) {
            logger.info(LOGM_DEMO_INFO, " set customized TPS {}", (Object)customizedTPS);
            isTPSChanged = true;
        } else if (this.customizedTPS != 0L && customizedTPS == 0L) {
            logger.info(LOGM_DEMO_INFO, " clear customized TPS to default");
            isTPSChanged = true;
        }
        if (isTPSChanged) {
            this.cycleStartMS = System.currentTimeMillis();
            this.accumulatedTrans = 0L;
        }
        this.customizedTPS = customizedTPS;
    }

    public SubmitConfig getSubmitConfig() {
        return this.submitConfig;
    }

    public static enum SUBMIT_GOAL {
        BYTES_PER_SECOND_PER_NODE,
        TRANS_PER_SECOND_PER_NODE,
        EVENTS_PER_SECOND_WHOLE_NETWORK,
        ROUNDS_PER_SECOND_WHOLE_NETWORK,
        TRANS_PER_EVENT_WHOLE_NETWORK,
        C2C_LATENCY;

        private static SUBMIT_GOAL[] allValues;

        public static SUBMIT_GOAL fromOrdinal(int n) {
            return allValues[n];
        }

        static {
            allValues = SUBMIT_GOAL.values();
        }
    }
}

