/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.platform.internal.Deserializer;
import com.swirlds.platform.internal.Serializer;
import com.swirlds.platform.network.PeerInfo;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.net.SocketException;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.CryptoUtils;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterUtils;

public final class Utilities {
    private static final Logger logger = LogManager.getLogger(Utilities.class);

    private Utilities() {
    }

    public static boolean parseBoolean(String par) {
        if (par == null) {
            return false;
        }
        String p = par.trim().toLowerCase();
        if (p.equals("")) {
            return false;
        }
        String f = p.substring(0, 1);
        return !p.equals("0") && !f.equals("f") && !f.equals("n") && !p.equals("off");
    }

    public static long[][] deepClone(long[][] original) {
        if (original == null) {
            return null;
        }
        long[][] result = (long[][])original.clone();
        for (int i = 0; i < original.length; ++i) {
            if (original[i] == null) continue;
            result[i] = (long[])original[i].clone();
        }
        return result;
    }

    public static int arrayCompare(@Nullable Bytes b1, @Nullable Bytes b2) {
        if (b1 == null && b2 == null) {
            return 0;
        }
        if (b1 == null && b2 != null) {
            return -1;
        }
        if (b1 != null && b2 == null) {
            return 1;
        }
        int i = 0;
        while ((long)i < Math.min(b1.length(), b2.length())) {
            if (b1.getByte((long)i) < b2.getByte((long)i)) {
                return -1;
            }
            if (b1.getByte((long)i) > b2.getByte((long)i)) {
                return 1;
            }
            ++i;
        }
        if (b1.length() < b2.length()) {
            return -1;
        }
        if (b1.length() > b2.length()) {
            return 1;
        }
        return 0;
    }

    public static int arrayCompare(@Nullable Bytes a1, @Nullable Bytes a2, byte[] whitening) {
        if (a1 == null && a2 == null) {
            return 0;
        }
        if (a1 != null && a2 == null) {
            return 1;
        }
        if (a1 == null && a2 != null) {
            return -1;
        }
        int maxLen = (int)Math.max(a1.length(), a2.length());
        int minLen = (int)Math.min(a1.length(), a2.length());
        if (whitening.length < maxLen) {
            whitening = Arrays.copyOf(whitening, maxLen);
        }
        for (int i = 0; i < minLen; ++i) {
            int b2;
            int b1 = a1.getByte((long)i) ^ whitening[i];
            if (b1 > (b2 = a2.getByte((long)i) ^ whitening[i])) {
                return 1;
            }
            if (b1 >= b2) continue;
            return -1;
        }
        if (a1.length() > a2.length()) {
            return 1;
        }
        if (a1.length() < a2.length()) {
            return -1;
        }
        return 0;
    }

    @Deprecated
    public static <T> void writeList(List<T> list, SerializableDataOutputStream stream, Serializer<T> serializer) throws IOException {
        if (list == null) {
            stream.writeInt(-1);
            return;
        }
        stream.writeInt(list.size());
        for (T t : list) {
            serializer.serialize(t, stream);
        }
    }

    @Deprecated
    public static <T> List<T> readList(SerializableDataInputStream stream, Supplier<List<T>> listSupplier, Deserializer<T> deserializer) throws IOException {
        int listSize = stream.readInt();
        if (listSize < 0) {
            return null;
        }
        List<T> list = listSupplier.get();
        for (int i = 0; i < listSize; ++i) {
            list.add(deserializer.deserialize(stream));
        }
        return list;
    }

    public static byte[] toBytes(long n) {
        byte[] bytes = new byte[8];
        Utilities.toBytes(n, bytes, 0);
        return bytes;
    }

    public static void toBytes(long n, byte[] bytes, int start) {
        for (int i = start + 8 - 1; i >= start; --i) {
            bytes[i] = (byte)n;
            n >>>= 8;
        }
    }

    public static long toLong(byte[] b) {
        return Utilities.toLong(b, 0);
    }

    public static long toLong(byte[] b, int start) {
        long result = 0L;
        for (int i = start; i < start + 8; ++i) {
            result <<= 8;
            result |= (long)(b[i] & 0xFF);
        }
        return result;
    }

    public static boolean isOrCausedBySocketException(Throwable ex) {
        return Utilities.isRootCauseSuppliedType(ex, SocketException.class);
    }

    public static boolean isCausedByIOException(Exception e) {
        return Utilities.isRootCauseSuppliedType(e, IOException.class);
    }

    public static boolean isRootCauseSuppliedType(Throwable t, Class<? extends Throwable> type) {
        if (t == null) {
            return false;
        }
        Throwable cause = t;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return type.isInstance(cause);
    }

    public static boolean hasAnyCauseSuppliedType(@NonNull Throwable throwable, @NonNull Class<? extends Throwable> type) {
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            if (!type.isInstance(cause)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public static List<PeerInfo> createPeerInfoList(@NonNull Roster roster, @NonNull NodeId selfId) {
        Objects.requireNonNull(roster);
        Objects.requireNonNull(selfId);
        return roster.rosterEntries().stream().filter(entry -> entry.nodeId() != selfId.id()).filter(entry -> CryptoUtils.checkCertificate((Certificate)RosterUtils.fetchGossipCaCertificate((RosterEntry)entry))).map(Utilities::toPeerInfo).toList();
    }

    @NonNull
    public static PeerInfo toPeerInfo(@NonNull RosterEntry entry) {
        Objects.requireNonNull(entry);
        return new PeerInfo(NodeId.of((long)entry.nodeId()), Objects.requireNonNull(RosterUtils.fetchHostname((RosterEntry)entry, (int)0)), RosterUtils.fetchPort((RosterEntry)entry, (int)0), Objects.requireNonNull(RosterUtils.fetchGossipCaCertificate((RosterEntry)entry)));
    }
}

