/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.communication.states;

import com.swirlds.platform.network.NetworkProtocolException;
import com.swirlds.platform.network.communication.NegotiationException;
import com.swirlds.platform.network.communication.NegotiationProtocols;
import com.swirlds.platform.network.communication.NegotiatorBytes;
import com.swirlds.platform.network.communication.states.NegotiationState;
import com.swirlds.platform.network.communication.states.NegotiationStateWithDescription;
import com.swirlds.platform.network.communication.states.ProtocolNegotiated;
import java.io.IOException;
import java.io.InputStream;

public class WaitForAcceptReject
extends NegotiationStateWithDescription {
    private final NegotiationProtocols protocols;
    private final InputStream byteInput;
    private final ProtocolNegotiated negotiated;
    private final NegotiationState sleep;

    public WaitForAcceptReject(NegotiationProtocols protocols, InputStream byteInput, ProtocolNegotiated negotiated, NegotiationState sleep) {
        this.protocols = protocols;
        this.byteInput = byteInput;
        this.negotiated = negotiated;
        this.sleep = sleep;
    }

    @Override
    public NegotiationState transition() throws NegotiationException, NetworkProtocolException, InterruptedException, IOException {
        int b = this.byteInput.read();
        NegotiatorBytes.checkByte(b);
        return switch (b) {
            case 254 -> {
                this.setDescription("received accept, running protocol");
                yield this.negotiated.runProtocol(this.protocols.initiateAccepted());
            }
            case 253 -> {
                this.protocols.initiateFailed();
                this.setDescription("received reject, sleeping");
                yield this.sleep;
            }
            default -> throw new NegotiationException(String.format("Unexpected byte %d, expected ACCEPT or REJECT", b));
        };
    }
}

