/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.recovery.internal;

import com.swirlds.common.io.IOIterator;
import com.swirlds.platform.recovery.internal.ObjectStreamIterator;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.SelfSerializable;
import org.hiero.consensus.model.event.CesEvent;

public class EventStreamSingleFileIterator
implements IOIterator<CesEvent> {
    private final ObjectStreamIterator<SelfSerializable> iterator;
    private final Hash startHash;
    private Hash endHash;
    private boolean finished;
    private final boolean toleratePartialFile;
    private final Path filePath;

    public EventStreamSingleFileIterator(Path objectStreamFile, boolean toleratePartialFile) throws IOException {
        this.toleratePartialFile = toleratePartialFile;
        this.filePath = objectStreamFile;
        this.iterator = new ObjectStreamIterator(new FileInputStream(objectStreamFile.toFile()), toleratePartialFile);
        if (!this.iterator.hasNext()) {
            this.startHash = null;
            throw new IOException("event stream file `%s` has no objects".formatted(this.filePath));
        }
        SelfSerializable firstObject = this.iterator.next();
        if (firstObject != null && firstObject.getClassId() != -854880720348154850L) {
            throw new IOException("Illegal object in event stream file `%s` at position 0, expected a Hash: ".formatted(this.filePath) + String.valueOf(firstObject.getClass()));
        }
        this.startHash = (Hash)firstObject;
        if (!this.hasNext()) {
            throw new IOException("event stream file `%s` does not contain any events".formatted(this.filePath));
        }
    }

    public void close() {
        this.iterator.close();
    }

    public boolean hasNext() throws IOException {
        if (!this.iterator.hasNext()) {
            this.finished = true;
            if (this.endHash == null && !this.toleratePartialFile) {
                throw new IOException("file `%s` terminates early".formatted(this.filePath));
            }
            return false;
        }
        if (this.endHash != null || !this.iterator.hasNext()) {
            this.finished = true;
            return false;
        }
        SelfSerializable next = this.iterator.peek();
        if (next == null) {
            this.finished = true;
            throw new IOException("null object in the event stream file `%s`".formatted(this.filePath));
        }
        if (next.getClassId() == -854880720348154850L) {
            this.finished = true;
            this.endHash = (Hash)next;
            return false;
        }
        if (next.getClassId() != -2139022923795222086L) {
            throw new IOException("Invalid object type found in event stream file `%s`: ".formatted(this.filePath) + String.valueOf(next.getClass()));
        }
        return true;
    }

    public CesEvent peek() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (CesEvent)this.iterator.peek();
    }

    public CesEvent next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (CesEvent)this.iterator.next();
    }

    public Hash getStartHash() {
        return this.startHash;
    }

    public Hash getEndHash() {
        return this.endHash;
    }

    public long getBytesRead() {
        return this.iterator.getBytesRead();
    }

    public boolean isDamaged() {
        return this.finished && this.endHash == null;
    }
}

