/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import com.swirlds.state.merkle.StateMetrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class SwirldStateManager {
    private final StateMetrics stateMetrics;
    private final AtomicReference<MerkleNodeState> stateRef = new AtomicReference();
    private final AtomicReference<MerkleNodeState> latestImmutableState = new AtomicReference();

    public SwirldStateManager(@NonNull PlatformContext platformContext, @NonNull Roster roster) {
        Objects.requireNonNull(platformContext);
        Objects.requireNonNull(roster);
        this.stateMetrics = new StateMetrics(platformContext.getMetrics());
    }

    public void setState(@NonNull MerkleNodeState state, boolean onInit) {
        Objects.requireNonNull(state);
        state.throwIfDestroyed("state must not be destroyed");
        state.throwIfImmutable("state must be mutable");
        if (onInit && this.stateRef.get() != null) {
            throw new IllegalStateException("Attempt to set initial state when there is already a state reference.");
        }
        this.updateStateRefs(state);
    }

    public MerkleNodeState getConsensusState() {
        return this.stateRef.get();
    }

    private void updateStateRefs(MerkleNodeState state) {
        long copyStart = System.nanoTime();
        MerkleNodeState copy = state.copy();
        copy.getRoot().reserve();
        long copyEnd = System.nanoTime();
        this.stateMetrics.stateCopyMicros((double)(copyEnd - copyStart) * 0.001);
        this.setLatestImmutableState(state);
        this.updateStateRef(copy);
    }

    private void updateStateRef(MerkleNodeState state) {
        MerkleNodeState currVal = this.stateRef.get();
        if (currVal != null) {
            currVal.release();
        }
        this.stateRef.set(state);
    }

    private void setLatestImmutableState(MerkleNodeState immutableState) {
        State currVal = (State)this.latestImmutableState.get();
        if (currVal != null) {
            currVal.release();
        }
        immutableState.getRoot().reserve();
        this.latestImmutableState.set(immutableState);
    }

    public MerkleNodeState getStateForSigning() {
        MerkleNodeState state = this.stateRef.get();
        this.updateStateRefs(state);
        return this.latestImmutableState.get();
    }
}

