/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.iss.internal;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.merkle.utility.SerializableLong;
import com.swirlds.platform.components.common.output.FatalErrorConsumer;
import com.swirlds.platform.config.StateConfig;
import com.swirlds.platform.scratchpad.Scratchpad;
import com.swirlds.platform.state.iss.IssHandler;
import com.swirlds.platform.state.iss.IssScratchpad;
import com.swirlds.platform.system.SystemExitCode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hiero.consensus.model.notification.IssNotification;

public class DefaultIssHandler
implements IssHandler {
    private final StateConfig stateConfig;
    private final FatalErrorConsumer fatalErrorConsumer;
    private final Scratchpad<IssScratchpad> issScratchpad;
    private boolean halted;

    public DefaultIssHandler(@NonNull PlatformContext platformContext, @NonNull FatalErrorConsumer fatalErrorConsumer, @NonNull Scratchpad<IssScratchpad> issScratchpad) {
        this.fatalErrorConsumer = Objects.requireNonNull(fatalErrorConsumer);
        this.stateConfig = (StateConfig)platformContext.getConfiguration().getConfigData(StateConfig.class);
        this.issScratchpad = Objects.requireNonNull(issScratchpad);
    }

    @Override
    public void issObserved(@NonNull IssNotification issNotification) {
        switch (issNotification.getIssType()) {
            case SELF_ISS: {
                this.selfIssObserved(issNotification.getRound());
                break;
            }
            case OTHER_ISS: {
                this.otherIssObserved();
                break;
            }
            case CATASTROPHIC_ISS: {
                this.catastrophicIssObserver(issNotification.getRound());
            }
        }
    }

    private void otherIssObserved() {
        if (this.halted) {
            return;
        }
        if (this.stateConfig.haltOnAnyIss()) {
            this.halted = true;
        }
    }

    private void updateIssRoundInScratchpad(long issRound) {
        this.issScratchpad.atomicOperation(data -> {
            SerializableLong lastIssRound = (SerializableLong)data.get(IssScratchpad.LAST_ISS_ROUND);
            if (lastIssRound == null || lastIssRound.getValue() < issRound) {
                data.put(IssScratchpad.LAST_ISS_ROUND, new SerializableLong(issRound));
                return true;
            }
            return false;
        });
    }

    private void selfIssObserved(@NonNull Long round) {
        if (this.halted) {
            return;
        }
        this.updateIssRoundInScratchpad(round);
        if (this.stateConfig.haltOnAnyIss()) {
            this.halted = true;
        } else if (this.stateConfig.automatedSelfIssRecovery()) {
            this.fatalErrorConsumer.fatalError("Self ISS", null, SystemExitCode.ISS);
        }
    }

    private void catastrophicIssObserver(@NonNull Long round) {
        if (this.halted) {
            return;
        }
        this.updateIssRoundInScratchpad(round);
        if (this.stateConfig.haltOnAnyIss() || this.stateConfig.haltOnCatastrophicIss()) {
            this.halted = true;
        }
    }
}

