/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.util;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.utility.throttle.RateLimitedLogger;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.config.PathsConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MarkerFileWriter {
    private static final Logger logger = LogManager.getLogger(MarkerFileWriter.class);
    private final RateLimitedLogger failedToWriteMarkerFileLogger;
    private final Path markerFileDirectory;
    private final Map<String, Boolean> markerFilesWritten = new ConcurrentHashMap<String, Boolean>();

    public MarkerFileWriter(@NonNull PlatformContext platformContext) {
        boolean enabled = ((PathsConfig)platformContext.getConfiguration().getConfigData(PathsConfig.class)).writePlatformMarkerFiles();
        Path markerFileDirectoryPath = ((PathsConfig)platformContext.getConfiguration().getConfigData(PathsConfig.class)).getMarkerFilesDir();
        this.failedToWriteMarkerFileLogger = new RateLimitedLogger(logger, platformContext.getTime(), Duration.ofMinutes(1L));
        Path directory = null;
        if (enabled) {
            if (markerFileDirectoryPath != null) {
                try {
                    Files.createDirectories(markerFileDirectoryPath, new FileAttribute[0]);
                    directory = markerFileDirectoryPath;
                }
                catch (IOException e) {
                    logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to create marker file directory: {}", (Object)markerFileDirectoryPath, (Object)e);
                }
            } else {
                logger.error(LogMarker.STARTUP.getMarker(), "Marker file writing is turned on but directory is null.");
            }
        }
        this.markerFileDirectory = directory;
    }

    public void writeMarkerFile(@NonNull String filename) {
        if (this.markerFileDirectory == null) {
            return;
        }
        this.markerFilesWritten.computeIfAbsent(filename, key -> {
            Path markerFile = this.markerFileDirectory.resolve(filename);
            try {
                if (Files.exists(markerFile, new LinkOption[0])) {
                    this.failedToWriteMarkerFileLogger.warn(LogMarker.ERROR.getMarker(), "Marker file already exists: {}", new Object[]{markerFile});
                    return true;
                }
                Files.createFile(markerFile, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.failedToWriteMarkerFileLogger.error(LogMarker.EXCEPTION.getMarker(), "Failed to create marker file: {}", new Object[]{markerFile, e});
            }
            return true;
        });
    }

    @Nullable
    public Path getMarkerFileDirectory() {
        return this.markerFileDirectory;
    }
}

