/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.iss;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.hedera.pbj.runtime.ParseException;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.merkle.utility.SerializableLong;
import com.swirlds.config.api.Configuration;
import com.swirlds.demo.iss.ISSTestingToolState;
import com.swirlds.demo.iss.IssTestingToolScratchpad;
import com.swirlds.demo.iss.PlannedIncident;
import com.swirlds.demo.iss.PlannedIss;
import com.swirlds.demo.iss.PlannedLogError;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.scratchpad.Scratchpad;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.system.InitTrigger;
import com.swirlds.platform.system.Platform;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.CompareTo;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.utility.ByteUtils;
import org.hiero.base.utility.NonCryptographicHashing;
import org.hiero.consensus.model.event.ConsensusEvent;
import org.hiero.consensus.model.event.Event;
import org.hiero.consensus.model.hashgraph.Round;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.AddressBook;
import org.hiero.consensus.model.transaction.ConsensusTransaction;
import org.hiero.consensus.model.transaction.ScopedSystemTransaction;
import org.hiero.consensus.model.transaction.Transaction;

public class ISSTestingToolConsensusStateEventHandler
implements ConsensusStateEventHandler<ISSTestingToolState> {
    private static final Logger logger = LogManager.getLogger(ISSTestingToolConsensusStateEventHandler.class);
    private static final Duration INCIDENT_WINDOW = Duration.ofSeconds(10L);
    private NodeId selfId;
    private Scratchpad<IssTestingToolScratchpad> scratchPad;

    public void onStateInitialized(@NonNull ISSTestingToolState state, @NonNull Platform platform, @NonNull InitTrigger trigger, @Nullable SemanticVersion previousVersion) {
        state.throwIfImmutable();
        state.initState(trigger, platform);
        this.selfId = platform.getSelfId();
        this.scratchPad = Scratchpad.create((Configuration)platform.getContext().getConfiguration(), (NodeId)this.selfId, IssTestingToolScratchpad.class, (String)"ISSTestingTool");
    }

    private void handleTransaction(@NonNull ISSTestingToolState state, @NonNull ConsensusTransaction transaction) {
        int delta = ByteUtils.byteArrayToInt((byte[])transaction.getApplicationTransaction().toByteArray(), (int)0);
        state.incrementRunningSum(delta);
    }

    public void onHandleConsensusRound(@NonNull Round round, @NonNull ISSTestingToolState state, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransactionCallback) {
        state.throwIfImmutable();
        Iterator eventIterator = round.iterator();
        while (eventIterator.hasNext()) {
            PlannedLogError plannedLogError;
            ConsensusEvent event = (ConsensusEvent)eventIterator.next();
            state.captureTimestamp(event);
            event.consensusTransactionIterator().forEachRemaining(transaction -> {
                if (this.areTransactionBytesSystemOnes((Transaction)transaction)) {
                    this.consumeSystemTransaction((Transaction)transaction, (Event)event, stateSignatureTransactionCallback);
                } else {
                    this.handleTransaction(state, (ConsensusTransaction)transaction);
                }
            });
            if (eventIterator.hasNext()) continue;
            Instant currentTimestamp = event.getConsensusTimestamp();
            Duration elapsedSinceGenesis = Duration.between(state.getGenesisTimestamp(), currentTimestamp);
            PlannedIss plannedIss = this.shouldTriggerIncident(elapsedSinceGenesis, currentTimestamp, state.getPlannedIssList());
            if (plannedIss != null) {
                this.triggerISS(round, plannedIss, elapsedSinceGenesis, currentTimestamp, state);
                this.scratchPad.set((Enum)IssTestingToolScratchpad.PROVOKED_ISS, (SelfSerializable)new SerializableLong(currentTimestamp.toEpochMilli()));
            }
            if ((plannedLogError = this.shouldTriggerIncident(elapsedSinceGenesis, currentTimestamp, state.getPlannedLogErrorList())) == null) continue;
            this.triggerLogError(plannedLogError, elapsedSinceGenesis);
        }
    }

    @Nullable
    private <T extends PlannedIncident> T shouldTriggerIncident(@NonNull Duration elapsedSinceGenesis, @NonNull Instant currentTimestamp, @NonNull List<T> plannedIncidentList) {
        Objects.requireNonNull(elapsedSinceGenesis);
        Objects.requireNonNull(currentTimestamp);
        Objects.requireNonNull(plannedIncidentList);
        ListIterator<T> plannedIncidentIterator = plannedIncidentList.listIterator();
        while (plannedIncidentIterator.hasNext()) {
            PlannedIncident plannedIncident = (PlannedIncident)plannedIncidentIterator.next();
            if (CompareTo.isLessThan((Comparable)elapsedSinceGenesis, (Object)plannedIncident.getTimeAfterGenesis())) {
                return null;
            }
            plannedIncidentIterator.remove();
            if (CompareTo.isGreaterThan((Comparable)elapsedSinceGenesis, (Object)plannedIncident.getTimeAfterGenesis().plus(INCIDENT_WINDOW))) {
                logger.info(LogMarker.STARTUP.getMarker(), "Planned {} skipped at {}. Planned time after genesis: {}. Elapsed time since genesis at skip: {}", (Object)plannedIncident.getDescriptor(), (Object)currentTimestamp, (Object)plannedIncident.getTimeAfterGenesis(), (Object)elapsedSinceGenesis);
                continue;
            }
            SerializableLong issLong = (SerializableLong)this.scratchPad.get((Enum)IssTestingToolScratchpad.PROVOKED_ISS);
            if (issLong != null) {
                Instant lastProvokedIssTime = Instant.ofEpochMilli(issLong.getValue());
                if (!lastProvokedIssTime.equals(currentTimestamp)) continue;
                logger.info(LogMarker.STARTUP.getMarker(), "Planned {} skipped at {} because this ISS was already invoked (likely before a restart).", (Object)plannedIncident.getDescriptor(), (Object)currentTimestamp);
                continue;
            }
            return (T)plannedIncident;
        }
        return null;
    }

    private void triggerISS(@NonNull Round round, @NonNull PlannedIss plannedIss, @NonNull Duration elapsedSinceGenesis, @NonNull Instant currentTimestamp, @NonNull ISSTestingToolState state) {
        Objects.requireNonNull(plannedIss);
        Objects.requireNonNull(elapsedSinceGenesis);
        Objects.requireNonNull(currentTimestamp);
        int hashPartitionIndex = plannedIss.getPartitionOfNode(this.selfId);
        if (hashPartitionIndex == this.findLargestPartition(round.getConsensusRoster(), plannedIss)) {
            return;
        }
        long hashPartitionSeed = NonCryptographicHashing.hash64((long)currentTimestamp.toEpochMilli(), (long)hashPartitionIndex);
        Random random = new Random(hashPartitionSeed);
        state.incrementRunningSum(random.nextInt());
        logger.info(LogMarker.STARTUP.getMarker(), "ISS intentionally provoked. This ISS was planned to occur at time after genesis {}, and actually occurred at time after genesis {} in round {}. This node ({}) is in partition {} and will agree with the hashes of all other nodes in partition {}. Nodes in other partitions are expected to have divergent hashes.", (Object)plannedIss.getTimeAfterGenesis(), (Object)elapsedSinceGenesis, (Object)round.getRoundNum(), (Object)this.selfId, (Object)hashPartitionIndex, (Object)hashPartitionIndex);
    }

    private int findLargestPartition(@NonNull Roster roster, @NonNull PlannedIss plannedIss) {
        HashMap<Integer, Long> partitionWeights = new HashMap<Integer, Long>();
        for (RosterEntry entry : roster.rosterEntries()) {
            int partition = plannedIss.getPartitionOfNode(NodeId.of((long)entry.nodeId()));
            long newWeight = partitionWeights.getOrDefault(partition, 0L) + entry.weight();
            partitionWeights.put(partition, newWeight);
        }
        int largestPartition = 0;
        long largestPartitionWeight = 0L;
        for (int partition = 0; partition < plannedIss.getPartitionCount(); ++partition) {
            if (partitionWeights.get(partition) == null || (Long)partitionWeights.get(partition) <= largestPartitionWeight) continue;
            largestPartition = partition;
            largestPartitionWeight = partitionWeights.getOrDefault(partition, 0L);
        }
        return largestPartition;
    }

    private void triggerLogError(@NonNull PlannedLogError plannedLogError, @NonNull Duration elapsedSinceGenesis) {
        Objects.requireNonNull(plannedLogError);
        Objects.requireNonNull(elapsedSinceGenesis);
        if (!plannedLogError.getNodeIds().contains(this.selfId)) {
            return;
        }
        logger.error(LogMarker.EXCEPTION.getMarker(), "This error was scheduled to be logged at time after genesis {}, and actually was logged at time after genesis {}.", (Object)plannedLogError.getTimeAfterGenesis(), (Object)elapsedSinceGenesis);
    }

    public void onPreHandle(@NonNull Event event, @NonNull ISSTestingToolState state, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransactionCallback) {
        event.forEachTransaction(transaction -> {
            if (this.areTransactionBytesSystemOnes((Transaction)transaction)) {
                this.consumeSystemTransaction((Transaction)transaction, event, stateSignatureTransactionCallback);
            }
        });
    }

    private boolean areTransactionBytesSystemOnes(Transaction transaction) {
        return transaction.getApplicationTransaction().length() > 4L;
    }

    private void consumeSystemTransaction(Transaction transaction, Event event, Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransactionCallback) {
        try {
            StateSignatureTransaction stateSignatureTransaction = (StateSignatureTransaction)StateSignatureTransaction.PROTOBUF.parse(transaction.getApplicationTransaction());
            stateSignatureTransactionCallback.accept((ScopedSystemTransaction<StateSignatureTransaction>)new ScopedSystemTransaction(event.getCreatorId(), event.getBirthRound(), (Object)stateSignatureTransaction));
        }
        catch (ParseException e) {
            logger.error("Failed to parse StateSignatureTransaction", (Throwable)e);
        }
    }

    public boolean onSealConsensusRound(@NonNull Round round, @NonNull ISSTestingToolState state) {
        return round.getRoundNum() % 5L == 0L;
    }

    public void onUpdateWeight(@NonNull ISSTestingToolState state, @NonNull AddressBook configAddressBook, @NonNull PlatformContext context) {
    }

    public void onNewRecoveredState(@NonNull ISSTestingToolState recoveredState) {
    }
}

