/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.metrics.impl;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.metrics.api.Counter;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.snapshot.Snapshot;
import com.swirlds.metrics.impl.AbstractMetric;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;

public class DefaultCounter
extends AbstractMetric
implements Counter {
    private static final String INCREASE_ONLY_ERROR_MESSAGE = "The value of a a Counter can only be increased";
    private final LongAdder adder = new LongAdder();

    public DefaultCounter(@NonNull Counter.Config config) {
        super((MetricConfig<?, ?>)config);
    }

    @NonNull
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, (Object)this.get()));
    }

    public long get() {
        return this.adder.sum();
    }

    public void add(long value) {
        if (value <= 0L) {
            throw new IllegalArgumentException(INCREASE_ONLY_ERROR_MESSAGE);
        }
        this.adder.add(value);
    }

    public void increment() {
        this.adder.increment();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("value", (Object)this.adder.sum()).toString();
    }
}

