/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.migration;

import com.swirlds.base.time.Time;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.crypto.MerkleCryptographyFactory;
import com.swirlds.common.metrics.noop.NoOpMetrics;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.demo.migration.AccountID;
import com.swirlds.demo.migration.MapValue;
import com.swirlds.merkle.map.MerkleMap;
import com.swirlds.merkledb.MerkleDbDataSourceBuilder;
import com.swirlds.merkledb.config.MerkleDbConfig;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.test.fixtures.state.TestingAppStateInitializer;
import com.swirlds.state.State;
import com.swirlds.state.test.fixtures.merkle.MerkleStateRoot;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.datasource.VirtualDataSourceBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.constructable.ConstructableIgnored;
import org.hiero.consensus.model.roster.AddressBook;

@ConstructableIgnored
public class MigrationTestingToolState
extends MerkleStateRoot<MigrationTestingToolState>
implements MerkleNodeState {
    private static final Logger logger = LogManager.getLogger(MigrationTestingToolState.class);
    private static final long INITIAL_ACCOUNTS_HINT = 1000000L;
    private static final long CLASS_ID = 1877348786352289444L;

    public MigrationTestingToolState() {
        super(TestingAppStateInitializer.CONFIGURATION, (Metrics)new NoOpMetrics(), Time.getCurrent(), MerkleCryptographyFactory.create((Configuration)TestingAppStateInitializer.CONFIGURATION));
    }

    private MigrationTestingToolState(MigrationTestingToolState that) {
        super((MerkleStateRoot)that);
        that.setImmutable(true);
        this.setImmutable(false);
    }

    protected long getRound() {
        return PlatformStateFacade.DEFAULT_PLATFORM_STATE_FACADE.roundOf((State)this);
    }

    public int getMinimumChildCount() {
        return 3;
    }

    public int getMaximumChildCount() {
        return 5;
    }

    public boolean childHasExpectedType(int index, long childClassId) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
            case 3: {
                return childClassId == -7776220400278906634L;
            }
            case 4: {
                return childClassId == -5151568835156514733L;
            }
        }
        return false;
    }

    public MerkleNode migrate(@NonNull Configuration configuration, int version) {
        if (version == 4) {
            TestingAppStateInitializer.DEFAULT.initRosterState((MerkleNodeState)this);
            return this;
        }
        return this;
    }

    public void addDeserializedChildren(List<MerkleNode> children, int version) {
        if (!children.isEmpty() && children.get(0) instanceof AddressBook) {
            children.set(0, null);
        }
        super.addDeserializedChildren(children, version);
    }

    MerkleMap<AccountID, MapValue> getMerkleMap() {
        return (MerkleMap)this.getChild(3);
    }

    void setMerkleMap(MerkleMap<AccountID, MapValue> map) {
        this.throwIfImmutable();
        this.setChild(3, (MerkleNode)map);
    }

    VirtualMap getVirtualMap() {
        return (VirtualMap)this.getChild(4);
    }

    protected void setVirtualMap(VirtualMap map) {
        this.setChild(4, (MerkleNode)map);
    }

    void genesisInit() {
        Configuration configuration = ConfigurationBuilder.create().autoDiscoverExtensions().build();
        this.setMerkleMap((MerkleMap<AccountID, MapValue>)new MerkleMap());
        MerkleDbConfig merkleDbConfig = (MerkleDbConfig)configuration.getConfigData(MerkleDbConfig.class);
        MerkleDbDataSourceBuilder dsBuilder = new MerkleDbDataSourceBuilder(configuration, 1000000L, merkleDbConfig.hashesRamToDiskThreshold());
        this.setVirtualMap(new VirtualMap("virtualMap", (VirtualDataSourceBuilder)dsBuilder, configuration));
    }

    @NonNull
    public MigrationTestingToolState copy() {
        this.throwIfImmutable();
        this.setImmutable(true);
        return new MigrationTestingToolState(this);
    }

    public long getClassId() {
        return 1877348786352289444L;
    }

    public int getVersion() {
        return 5;
    }

    public int getMinimumSupportedVersion() {
        return 4;
    }

    protected MigrationTestingToolState copyingConstructor() {
        return new MigrationTestingToolState(this);
    }

    private static class ChildIndices {
        public static final int UNUSED_PLATFORM_STATE = 0;
        public static final int UNUSED_ROSTERS = 1;
        public static final int UNUSED_ROSTER_STATE = 2;
        public static final int MERKLE_MAP = 3;
        public static final int VIRTUAL_MAP = 4;
        public static final int CHILD_COUNT = 5;
        public static final int OLD_CHILD_COUNT = 3;

        private ChildIndices() {
        }
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;
        public static final int MIGRATE_TO_SERIALIZABLE = 2;
        public static final int MERKLE_MAP_REFACTOR = 3;
        public static final int VIRTUAL_MAP = 4;
        public static final int ROSTERS = 5;

        private ClassVersion() {
        }
    }
}

