/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.consistency;

import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.hedera.pbj.runtime.ParseException;
import com.swirlds.base.time.Time;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.crypto.MerkleCryptographyFactory;
import com.swirlds.common.metrics.noop.NoOpMetrics;
import com.swirlds.config.api.Configuration;
import com.swirlds.demo.consistency.ConsistencyTestingToolRound;
import com.swirlds.demo.consistency.TransactionHandlingHistory;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.test.fixtures.state.TestingAppStateInitializer;
import com.swirlds.state.State;
import com.swirlds.state.test.fixtures.merkle.MerkleStateRoot;
import com.swirlds.state.test.fixtures.merkle.singleton.StringLeaf;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.constructable.ConstructableIgnored;
import org.hiero.base.utility.ByteUtils;
import org.hiero.base.utility.NonCryptographicHashing;
import org.hiero.consensus.model.event.Event;
import org.hiero.consensus.model.hashgraph.Round;
import org.hiero.consensus.model.transaction.ConsensusTransaction;
import org.hiero.consensus.model.transaction.ScopedSystemTransaction;
import org.hiero.consensus.model.transaction.Transaction;

@ConstructableIgnored
public class ConsistencyTestingToolState
extends MerkleStateRoot<ConsistencyTestingToolState>
implements MerkleNodeState {
    private static final Logger logger = LogManager.getLogger(ConsistencyTestingToolState.class);
    private static final long CLASS_ID = -2737138505820308094L;
    private static final int STATE_LONG_INDEX = 3;
    private static final int ROUND_HANDLED_INDEX = 4;
    private long stateLong = 0L;
    private long roundsHandled = 0L;
    private final TransactionHandlingHistory transactionHandlingHistory;
    private final Set<Long> transactionsAwaitingPostHandle;

    public ConsistencyTestingToolState() {
        super(TestingAppStateInitializer.CONFIGURATION, (Metrics)new NoOpMetrics(), Time.getCurrent(), MerkleCryptographyFactory.create((Configuration)TestingAppStateInitializer.CONFIGURATION));
        this.transactionHandlingHistory = new TransactionHandlingHistory();
        this.transactionsAwaitingPostHandle = ConcurrentHashMap.newKeySet();
        logger.info(LogMarker.STARTUP.getMarker(), "New State Constructed.");
    }

    void initState(Path logFilePath) {
        StringLeaf roundsHandledLeaf;
        StringLeaf stateLongLeaf = (StringLeaf)this.getChild(3);
        if (stateLongLeaf != null && stateLongLeaf.getLabel() != null) {
            this.stateLong = Long.parseLong(stateLongLeaf.getLabel());
            logger.info(LogMarker.STARTUP.getMarker(), "State initialized with state long {}.", (Object)this.stateLong);
        }
        if ((roundsHandledLeaf = (StringLeaf)this.getChild(4)) != null && roundsHandledLeaf.getLabel() != null) {
            this.roundsHandled = Long.parseLong(roundsHandledLeaf.getLabel());
            logger.info(LogMarker.STARTUP.getMarker(), "State initialized with {} rounds handled.", (Object)this.roundsHandled);
        }
        this.transactionHandlingHistory.init(logFilePath);
    }

    protected long getRound() {
        return PlatformStateFacade.DEFAULT_PLATFORM_STATE_FACADE.roundOf((State)this);
    }

    long getRoundsHandled() {
        return this.roundsHandled;
    }

    void incrementRoundsHandled() {
        ++this.roundsHandled;
        this.setChild(4, (MerkleNode)new StringLeaf(Long.toString(this.roundsHandled)));
    }

    long getStateLong() {
        return this.stateLong;
    }

    void setStateLong(long stateLong) {
        this.stateLong = stateLong;
        this.setChild(3, (MerkleNode)new StringLeaf(Long.toString(stateLong)));
    }

    private ConsistencyTestingToolState(@NonNull ConsistencyTestingToolState that) {
        super((MerkleStateRoot)Objects.requireNonNull(that));
        this.stateLong = that.stateLong;
        this.roundsHandled = that.roundsHandled;
        this.transactionHandlingHistory = that.transactionHandlingHistory;
        this.transactionsAwaitingPostHandle = that.transactionsAwaitingPostHandle;
    }

    public long getClassId() {
        return -2737138505820308094L;
    }

    public int getVersion() {
        return 1;
    }

    public int getMinimumSupportedVersion() {
        return 1;
    }

    private void processRound(Round round) {
        this.stateLong = NonCryptographicHashing.hash64((long)this.stateLong, (long)round.getRoundNum());
        this.transactionHandlingHistory.processRound(ConsistencyTestingToolRound.fromRound(round, this.stateLong));
        this.setChild(3, (MerkleNode)new StringLeaf(Long.toString(this.stateLong)));
    }

    void processTransactions(Round round, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransaction) {
        this.incrementRoundsHandled();
        round.forEachEventTransaction((ev, tx) -> {
            if (ConsistencyTestingToolState.isSystemTransaction((Transaction)tx)) {
                this.consumeSystemTransaction((Transaction)tx, (Event)ev, stateSignatureTransaction);
            } else {
                this.applyTransactionToState((ConsensusTransaction)tx);
            }
        });
        this.processRound(round);
    }

    void processPrehandle(Transaction transaction) {
        long transactionContents = ConsistencyTestingToolState.getTransactionContents(transaction);
        if (!this.transactionsAwaitingPostHandle.add(transactionContents)) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Transaction {} was prehandled more than once.", (Object)transactionContents);
        }
    }

    private void applyTransactionToState(@NonNull ConsensusTransaction transaction) {
        Objects.requireNonNull(transaction);
        long transactionContents = ConsistencyTestingToolState.getTransactionContents((Transaction)transaction);
        if (!this.transactionsAwaitingPostHandle.remove(transactionContents)) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Transaction {} was not prehandled.", (Object)transactionContents);
        }
        this.stateLong = NonCryptographicHashing.hash64((long)this.stateLong, (long)transactionContents);
        this.setChild(3, (MerkleNode)new StringLeaf(Long.toString(this.stateLong)));
    }

    private static long getTransactionContents(Transaction transaction) {
        return ByteUtils.byteArrayToLong((byte[])transaction.getApplicationTransaction().toByteArray(), (int)0);
    }

    static boolean isSystemTransaction(@NonNull Transaction transaction) {
        return transaction.getApplicationTransaction().length() > 8L;
    }

    void consumeSystemTransaction(@NonNull Transaction transaction, @NonNull Event event, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransactionCallback) {
        try {
            StateSignatureTransaction stateSignatureTransaction = (StateSignatureTransaction)StateSignatureTransaction.PROTOBUF.parse(transaction.getApplicationTransaction());
            stateSignatureTransactionCallback.accept((ScopedSystemTransaction<StateSignatureTransaction>)new ScopedSystemTransaction(event.getCreatorId(), event.getBirthRound(), (Object)stateSignatureTransaction));
        }
        catch (ParseException e) {
            logger.error("Failed to parse StateSignatureTransaction", (Throwable)e);
        }
    }

    @NonNull
    public synchronized ConsistencyTestingToolState copy() {
        this.throwIfImmutable();
        this.setImmutable(true);
        return new ConsistencyTestingToolState(this);
    }

    protected ConsistencyTestingToolState copyingConstructor() {
        return new ConsistencyTestingToolState(this);
    }

    public MerkleNode migrate(@NonNull Configuration configuration, int version) {
        return this;
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

